@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the label.
 * @property value The value of the label.
 */
public data class PrometheusAlertRuleLabelArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleLabelArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleLabelArgs =
        com.pulumi.alicloud.arms.inputs.PrometheusAlertRuleLabelArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrometheusAlertRuleLabelArgs].
 */
@PulumiTagMarker
public class PrometheusAlertRuleLabelArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the label.
     */
    @JvmName("uvrklrlefxnarbsh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the label.
     */
    @JvmName("gtrccoogbogdpwrc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the label.
     */
    @JvmName("ecamckujepuploar")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the label.
     */
    @JvmName("iykrmfvmfnbluvud")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PrometheusAlertRuleLabelArgs = PrometheusAlertRuleLabelArgs(
        name = name,
        `value` = `value`,
    )
}
