@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskAvailableAssertionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expect Expected value.
 * @property operator Condition: gt: greater than; gte: greater than or equal to; lt: less than; te: less than or equal to; eq: equal to; neq: not equal to; ctn: contains; nctn: does not contain; exist: exists; n_exist: does not exist; belong: belongs to; reg_match: regular matching.
 * @property target Check the target. If the target is HttpResCode, HttpResBody, or httpressetime, you do not need to specify the target. If the target is HttpResHead, you need to specify the key in the header. If the target is HttpResHead, you need to use jsonPath.
 * @property type Assertion type, including: httpresead, httpresead, HttpResBody, HttpResBodyJson, httpressetime, IcmpPackLoss (packet loss rate), IcmpPackMaxLatency (maximum packet delay ms), icmppackwebscreen, fmppackavglatency (average delay rendering), TraceRouteHops (number of hops), dnsarecname, websiteOnload (full load time), see the supplement below for specific use.
 */
public data class SyntheticTaskAvailableAssertionArgs(
    public val `expect`: Output<String>,
    public val `operator`: Output<String>,
    public val target: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskAvailableAssertionArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskAvailableAssertionArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskAvailableAssertionArgs.builder()
            .`expect`(`expect`.applyValue({ args0 -> args0 }))
            .`operator`(`operator`.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskAvailableAssertionArgs].
 */
@PulumiTagMarker
public class SyntheticTaskAvailableAssertionArgsBuilder internal constructor() {
    private var `expect`: Output<String>? = null

    private var `operator`: Output<String>? = null

    private var target: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Expected value.
     */
    @JvmName("edvkkilafedbifns")
    public suspend fun `expect`(`value`: Output<String>) {
        this.`expect` = value
    }

    /**
     * @param value Condition: gt: greater than; gte: greater than or equal to; lt: less than; te: less than or equal to; eq: equal to; neq: not equal to; ctn: contains; nctn: does not contain; exist: exists; n_exist: does not exist; belong: belongs to; reg_match: regular matching.
     */
    @JvmName("acrknewtvdlqvude")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value Check the target. If the target is HttpResCode, HttpResBody, or httpressetime, you do not need to specify the target. If the target is HttpResHead, you need to specify the key in the header. If the target is HttpResHead, you need to use jsonPath.
     */
    @JvmName("qhbgomoivarnjuoq")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Assertion type, including: httpresead, httpresead, HttpResBody, HttpResBodyJson, httpressetime, IcmpPackLoss (packet loss rate), IcmpPackMaxLatency (maximum packet delay ms), icmppackwebscreen, fmppackavglatency (average delay rendering), TraceRouteHops (number of hops), dnsarecname, websiteOnload (full load time), see the supplement below for specific use.
     */
    @JvmName("lepxlchamwpqwkox")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Expected value.
     */
    @JvmName("ftcqrimpgccssvha")
    public suspend fun `expect`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`expect` = mapped
    }

    /**
     * @param value Condition: gt: greater than; gte: greater than or equal to; lt: less than; te: less than or equal to; eq: equal to; neq: not equal to; ctn: contains; nctn: does not contain; exist: exists; n_exist: does not exist; belong: belongs to; reg_match: regular matching.
     */
    @JvmName("ubxilvcyrtqimewt")
    public suspend fun `operator`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Check the target. If the target is HttpResCode, HttpResBody, or httpressetime, you do not need to specify the target. If the target is HttpResHead, you need to specify the key in the header. If the target is HttpResHead, you need to use jsonPath.
     */
    @JvmName("snjwyshbcfdpitqg")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Assertion type, including: httpresead, httpresead, HttpResBody, HttpResBodyJson, httpressetime, IcmpPackLoss (packet loss rate), IcmpPackMaxLatency (maximum packet delay ms), icmppackwebscreen, fmppackavglatency (average delay rendering), TraceRouteHops (number of hops), dnsarecname, websiteOnload (full load time), see the supplement below for specific use.
     */
    @JvmName("uvuugrkykxxrnogr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SyntheticTaskAvailableAssertionArgs = SyntheticTaskAvailableAssertionArgs(
        `expect` = `expect` ?: throw PulumiNullFieldException("expect"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        target = target,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
