@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customHost Custom host. See `custom_host` below.
 * @property ipType IpType.
 * @property isOpenTrace Whether to enable link tracking.
 * @property monitorSamples Whether the monitoring samples are evenly distributed:
 * - 0: No
 * 1: Yes.
 * @property traceClientType Link trace client type:
 * - 0:ARMS Agent
 * - 1:OpenTelemetry
 * - 2:Jaeger.
 * @property xtraceRegion The link data is reported to the region.
 */
public data class SyntheticTaskCommonSettingArgs(
    public val customHost: Output<SyntheticTaskCommonSettingCustomHostArgs>? = null,
    public val ipType: Output<Int>? = null,
    public val isOpenTrace: Output<Boolean>? = null,
    public val monitorSamples: Output<Int>? = null,
    public val traceClientType: Output<Int>? = null,
    public val xtraceRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingArgs.builder()
            .customHost(customHost?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipType(ipType?.applyValue({ args0 -> args0 }))
            .isOpenTrace(isOpenTrace?.applyValue({ args0 -> args0 }))
            .monitorSamples(monitorSamples?.applyValue({ args0 -> args0 }))
            .traceClientType(traceClientType?.applyValue({ args0 -> args0 }))
            .xtraceRegion(xtraceRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskCommonSettingArgs].
 */
@PulumiTagMarker
public class SyntheticTaskCommonSettingArgsBuilder internal constructor() {
    private var customHost: Output<SyntheticTaskCommonSettingCustomHostArgs>? = null

    private var ipType: Output<Int>? = null

    private var isOpenTrace: Output<Boolean>? = null

    private var monitorSamples: Output<Int>? = null

    private var traceClientType: Output<Int>? = null

    private var xtraceRegion: Output<String>? = null

    /**
     * @param value Custom host. See `custom_host` below.
     */
    @JvmName("hykphyrhvqgrojxk")
    public suspend fun customHost(`value`: Output<SyntheticTaskCommonSettingCustomHostArgs>) {
        this.customHost = value
    }

    /**
     * @param value IpType.
     */
    @JvmName("wdiwadwbmfsvfqaq")
    public suspend fun ipType(`value`: Output<Int>) {
        this.ipType = value
    }

    /**
     * @param value Whether to enable link tracking.
     */
    @JvmName("ucmuqyycfryesbvq")
    public suspend fun isOpenTrace(`value`: Output<Boolean>) {
        this.isOpenTrace = value
    }

    /**
     * @param value Whether the monitoring samples are evenly distributed:
     * - 0: No
     * 1: Yes.
     */
    @JvmName("smryenwualcmljfx")
    public suspend fun monitorSamples(`value`: Output<Int>) {
        this.monitorSamples = value
    }

    /**
     * @param value Link trace client type:
     * - 0:ARMS Agent
     * - 1:OpenTelemetry
     * - 2:Jaeger.
     */
    @JvmName("lrcgssnotiuyddpv")
    public suspend fun traceClientType(`value`: Output<Int>) {
        this.traceClientType = value
    }

    /**
     * @param value The link data is reported to the region.
     */
    @JvmName("fmuhgfeyedxgoxpn")
    public suspend fun xtraceRegion(`value`: Output<String>) {
        this.xtraceRegion = value
    }

    /**
     * @param value Custom host. See `custom_host` below.
     */
    @JvmName("xwykqkdpgckotobp")
    public suspend fun customHost(`value`: SyntheticTaskCommonSettingCustomHostArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHost = mapped
    }

    /**
     * @param argument Custom host. See `custom_host` below.
     */
    @JvmName("sloohrqxnokpiywg")
    public suspend fun customHost(argument: suspend SyntheticTaskCommonSettingCustomHostArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskCommonSettingCustomHostArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customHost = mapped
    }

    /**
     * @param value IpType.
     */
    @JvmName("vtrnkgqfntjiiyhp")
    public suspend fun ipType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipType = mapped
    }

    /**
     * @param value Whether to enable link tracking.
     */
    @JvmName("lflsxcagaywuynsf")
    public suspend fun isOpenTrace(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOpenTrace = mapped
    }

    /**
     * @param value Whether the monitoring samples are evenly distributed:
     * - 0: No
     * 1: Yes.
     */
    @JvmName("rjkdapihdjrhtqin")
    public suspend fun monitorSamples(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorSamples = mapped
    }

    /**
     * @param value Link trace client type:
     * - 0:ARMS Agent
     * - 1:OpenTelemetry
     * - 2:Jaeger.
     */
    @JvmName("ttkcsqtkhbxigsmw")
    public suspend fun traceClientType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traceClientType = mapped
    }

    /**
     * @param value The link data is reported to the region.
     */
    @JvmName("bpjgfqfvjbgjbgjq")
    public suspend fun xtraceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xtraceRegion = mapped
    }

    internal fun build(): SyntheticTaskCommonSettingArgs = SyntheticTaskCommonSettingArgs(
        customHost = customHost,
        ipType = ipType,
        isOpenTrace = isOpenTrace,
        monitorSamples = monitorSamples,
        traceClientType = traceClientType,
        xtraceRegion = xtraceRegion,
    )
}
