@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hosts The host list. See `hosts` below.
 * @property selectType Selection method:
 * - 0: Random
 * - 1: Polling.
 */
public data class SyntheticTaskCommonSettingCustomHostArgs(
    public val hosts: Output<List<SyntheticTaskCommonSettingCustomHostHostArgs>>,
    public val selectType: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostArgs.builder()
            .hosts(hosts.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .selectType(selectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskCommonSettingCustomHostArgs].
 */
@PulumiTagMarker
public class SyntheticTaskCommonSettingCustomHostArgsBuilder internal constructor() {
    private var hosts: Output<List<SyntheticTaskCommonSettingCustomHostHostArgs>>? = null

    private var selectType: Output<Int>? = null

    /**
     * @param value The host list. See `hosts` below.
     */
    @JvmName("xcwtiiqahcnejrui")
    public suspend fun hosts(`value`: Output<List<SyntheticTaskCommonSettingCustomHostHostArgs>>) {
        this.hosts = value
    }

    @JvmName("ntyoqxqrbfiydivq")
    public suspend fun hosts(vararg values: Output<SyntheticTaskCommonSettingCustomHostHostArgs>) {
        this.hosts = Output.all(values.asList())
    }

    /**
     * @param values The host list. See `hosts` below.
     */
    @JvmName("dwhseqpgshiiqknu")
    public suspend fun hosts(values: List<Output<SyntheticTaskCommonSettingCustomHostHostArgs>>) {
        this.hosts = Output.all(values)
    }

    /**
     * @param value Selection method:
     * - 0: Random
     * - 1: Polling.
     */
    @JvmName("kngkivxmyeeowsts")
    public suspend fun selectType(`value`: Output<Int>) {
        this.selectType = value
    }

    /**
     * @param value The host list. See `hosts` below.
     */
    @JvmName("hsniayfiocuukqfa")
    public suspend fun hosts(`value`: List<SyntheticTaskCommonSettingCustomHostHostArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param argument The host list. See `hosts` below.
     */
    @JvmName("mhjatygpuqjbwtjw")
    public suspend fun hosts(argument: List<suspend SyntheticTaskCommonSettingCustomHostHostArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SyntheticTaskCommonSettingCustomHostHostArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.hosts = mapped
    }

    /**
     * @param argument The host list. See `hosts` below.
     */
    @JvmName("saetyyigbeqnmjso")
    public suspend fun hosts(vararg argument: suspend SyntheticTaskCommonSettingCustomHostHostArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SyntheticTaskCommonSettingCustomHostHostArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.hosts = mapped
    }

    /**
     * @param argument The host list. See `hosts` below.
     */
    @JvmName("tvxnpjfvdplhayqk")
    public suspend fun hosts(argument: suspend SyntheticTaskCommonSettingCustomHostHostArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SyntheticTaskCommonSettingCustomHostHostArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.hosts = mapped
    }

    /**
     * @param values The host list. See `hosts` below.
     */
    @JvmName("crkyxbptwjqlwypt")
    public suspend fun hosts(vararg values: SyntheticTaskCommonSettingCustomHostHostArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param value Selection method:
     * - 0: Random
     * - 1: Polling.
     */
    @JvmName("tdvohsexonabvhcu")
    public suspend fun selectType(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectType = mapped
    }

    internal fun build(): SyntheticTaskCommonSettingCustomHostArgs =
        SyntheticTaskCommonSettingCustomHostArgs(
            hosts = hosts ?: throw PulumiNullFieldException("hosts"),
            selectType = selectType ?: throw PulumiNullFieldException("selectType"),
        )
}
