@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostHostArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property domain Domain Name.
 * @property ipType IpType.
 * @property ips The IP list.
 */
public data class SyntheticTaskCommonSettingCustomHostHostArgs(
    public val domain: Output<String>,
    public val ipType: Output<Int>,
    public val ips: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostHostArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostHostArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskCommonSettingCustomHostHostArgs.builder()
            .domain(domain.applyValue({ args0 -> args0 }))
            .ipType(ipType.applyValue({ args0 -> args0 }))
            .ips(ips.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SyntheticTaskCommonSettingCustomHostHostArgs].
 */
@PulumiTagMarker
public class SyntheticTaskCommonSettingCustomHostHostArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var ipType: Output<Int>? = null

    private var ips: Output<List<String>>? = null

    /**
     * @param value Domain Name.
     */
    @JvmName("ljifdxieyfxyydxm")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value IpType.
     */
    @JvmName("qmhnpibmkfhxcwiu")
    public suspend fun ipType(`value`: Output<Int>) {
        this.ipType = value
    }

    /**
     * @param value The IP list.
     */
    @JvmName("ancghyfcsmbkoluu")
    public suspend fun ips(`value`: Output<List<String>>) {
        this.ips = value
    }

    @JvmName("ahhnjjrkohyflrfp")
    public suspend fun ips(vararg values: Output<String>) {
        this.ips = Output.all(values.asList())
    }

    /**
     * @param values The IP list.
     */
    @JvmName("fptgfqscuycqryba")
    public suspend fun ips(values: List<Output<String>>) {
        this.ips = Output.all(values)
    }

    /**
     * @param value Domain Name.
     */
    @JvmName("tjjbwqkvdtjkvbcj")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value IpType.
     */
    @JvmName("mhssuqgnexeghpck")
    public suspend fun ipType(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipType = mapped
    }

    /**
     * @param value The IP list.
     */
    @JvmName("ieykiyjtdgcgrxea")
    public suspend fun ips(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ips = mapped
    }

    /**
     * @param values The IP list.
     */
    @JvmName("irfeaptsnrvcsktx")
    public suspend fun ips(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ips = mapped
    }

    internal fun build(): SyntheticTaskCommonSettingCustomHostHostArgs =
        SyntheticTaskCommonSettingCustomHostHostArgs(
            domain = domain ?: throw PulumiNullFieldException("domain"),
            ipType = ipType ?: throw PulumiNullFieldException("ipType"),
            ips = ips ?: throw PulumiNullFieldException("ips"),
        )
}
