@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskCustomPeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endHour End hours, 0-24.
 * @property startHour Starting hours, 0-24.
 */
public data class SyntheticTaskCustomPeriodArgs(
    public val endHour: Output<Int>? = null,
    public val startHour: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskCustomPeriodArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskCustomPeriodArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskCustomPeriodArgs.builder()
            .endHour(endHour?.applyValue({ args0 -> args0 }))
            .startHour(startHour?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskCustomPeriodArgs].
 */
@PulumiTagMarker
public class SyntheticTaskCustomPeriodArgsBuilder internal constructor() {
    private var endHour: Output<Int>? = null

    private var startHour: Output<Int>? = null

    /**
     * @param value End hours, 0-24.
     */
    @JvmName("ghfrgdqmgjlkbyno")
    public suspend fun endHour(`value`: Output<Int>) {
        this.endHour = value
    }

    /**
     * @param value Starting hours, 0-24.
     */
    @JvmName("fryajfftiofjuusd")
    public suspend fun startHour(`value`: Output<Int>) {
        this.startHour = value
    }

    /**
     * @param value End hours, 0-24.
     */
    @JvmName("geojtdmylylalbtx")
    public suspend fun endHour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endHour = mapped
    }

    /**
     * @param value Starting hours, 0-24.
     */
    @JvmName("fqkteadmoknabpab")
    public suspend fun startHour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startHour = mapped
    }

    internal fun build(): SyntheticTaskCustomPeriodArgs = SyntheticTaskCustomPeriodArgs(
        endHour = endHour,
        startHour = startHour,
    )
}
