@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cityCode The city code of monitor.
 * @property clientType The type of monitor.
 * @property operatorCode The operator code of monitor.
 */
public data class SyntheticTaskMonitorArgs(
    public val cityCode: Output<String>,
    public val clientType: Output<Int>,
    public val operatorCode: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorArgs.builder()
            .cityCode(cityCode.applyValue({ args0 -> args0 }))
            .clientType(clientType.applyValue({ args0 -> args0 }))
            .operatorCode(operatorCode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorArgsBuilder internal constructor() {
    private var cityCode: Output<String>? = null

    private var clientType: Output<Int>? = null

    private var operatorCode: Output<String>? = null

    /**
     * @param value The city code of monitor.
     */
    @JvmName("sskenalmosfveypa")
    public suspend fun cityCode(`value`: Output<String>) {
        this.cityCode = value
    }

    /**
     * @param value The type of monitor.
     */
    @JvmName("upoyddhumbbvurrj")
    public suspend fun clientType(`value`: Output<Int>) {
        this.clientType = value
    }

    /**
     * @param value The operator code of monitor.
     */
    @JvmName("ihukkkgwrnvfxnkc")
    public suspend fun operatorCode(`value`: Output<String>) {
        this.operatorCode = value
    }

    /**
     * @param value The city code of monitor.
     */
    @JvmName("mdlefkcwgohbliim")
    public suspend fun cityCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cityCode = mapped
    }

    /**
     * @param value The type of monitor.
     */
    @JvmName("majqrmavqeiluiwy")
    public suspend fun clientType(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientType = mapped
    }

    /**
     * @param value The operator code of monitor.
     */
    @JvmName("bcbmvmbrhmmmugcv")
    public suspend fun operatorCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorCode = mapped
    }

    internal fun build(): SyntheticTaskMonitorArgs = SyntheticTaskMonitorArgs(
        cityCode = cityCode ?: throw PulumiNullFieldException("cityCode"),
        clientType = clientType ?: throw PulumiNullFieldException("clientType"),
        operatorCode = operatorCode ?: throw PulumiNullFieldException("operatorCode"),
    )
}
