@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property connectTimeout Connection timeout, in ms. Default 5000. Optional range: 1000-300000ms.
 * @property method HTTP method, GET or POST.
 * @property requestBody HTTP request body. See `request_body` below.
 * @property requestHeaders HTTP request header.
 * @property targetUrl The target URL.
 * @property timeout TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
 */
public data class SyntheticTaskMonitorConfApiHttpArgs(
    public val connectTimeout: Output<Int>? = null,
    public val method: Output<String>? = null,
    public val requestBody: Output<SyntheticTaskMonitorConfApiHttpRequestBodyArgs>? = null,
    public val requestHeaders: Output<Map<String, String>>? = null,
    public val targetUrl: Output<String>,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpArgs.builder()
            .connectTimeout(connectTimeout?.applyValue({ args0 -> args0 }))
            .method(method?.applyValue({ args0 -> args0 }))
            .requestBody(requestBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requestHeaders(
                requestHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetUrl(targetUrl.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfApiHttpArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfApiHttpArgsBuilder internal constructor() {
    private var connectTimeout: Output<Int>? = null

    private var method: Output<String>? = null

    private var requestBody: Output<SyntheticTaskMonitorConfApiHttpRequestBodyArgs>? = null

    private var requestHeaders: Output<Map<String, String>>? = null

    private var targetUrl: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value Connection timeout, in ms. Default 5000. Optional range: 1000-300000ms.
     */
    @JvmName("mlkmieomfemclmfi")
    public suspend fun connectTimeout(`value`: Output<Int>) {
        this.connectTimeout = value
    }

    /**
     * @param value HTTP method, GET or POST.
     */
    @JvmName("gnphuhxpdrdyfuan")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value HTTP request body. See `request_body` below.
     */
    @JvmName("eweddjhnracjtblb")
    public suspend fun requestBody(`value`: Output<SyntheticTaskMonitorConfApiHttpRequestBodyArgs>) {
        this.requestBody = value
    }

    /**
     * @param value HTTP request header.
     */
    @JvmName("qqioixrtvvtdqqsy")
    public suspend fun requestHeaders(`value`: Output<Map<String, String>>) {
        this.requestHeaders = value
    }

    /**
     * @param value The target URL.
     */
    @JvmName("niljerabyxdeghaq")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("iskhdrigtfujvnsi")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Connection timeout, in ms. Default 5000. Optional range: 1000-300000ms.
     */
    @JvmName("bedgtwnryfkxwcau")
    public suspend fun connectTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectTimeout = mapped
    }

    /**
     * @param value HTTP method, GET or POST.
     */
    @JvmName("vgcfmyhskhpnldji")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value HTTP request body. See `request_body` below.
     */
    @JvmName("mbqihucrvckjmeng")
    public suspend fun requestBody(`value`: SyntheticTaskMonitorConfApiHttpRequestBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBody = mapped
    }

    /**
     * @param argument HTTP request body. See `request_body` below.
     */
    @JvmName("cjxynsfeqtwyxymv")
    public suspend fun requestBody(argument: suspend SyntheticTaskMonitorConfApiHttpRequestBodyArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfApiHttpRequestBodyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.requestBody = mapped
    }

    /**
     * @param value HTTP request header.
     */
    @JvmName("ccdllnjycjfbqiqg")
    public suspend fun requestHeaders(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaders = mapped
    }

    /**
     * @param values HTTP request header.
     */
    @JvmName("mjimctplcfsdwyfa")
    public fun requestHeaders(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestHeaders = mapped
    }

    /**
     * @param value The target URL.
     */
    @JvmName("nfypfuhrqmqwmwhp")
    public suspend fun targetUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("nmpfbmcunuoxmubb")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfApiHttpArgs = SyntheticTaskMonitorConfApiHttpArgs(
        connectTimeout = connectTimeout,
        method = method,
        requestBody = requestBody,
        requestHeaders = requestHeaders,
        targetUrl = targetUrl ?: throw PulumiNullFieldException("targetUrl"),
        timeout = timeout,
    )
}
