@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpRequestBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The request body content, in JSON string format. When the type is text/plain,application/json,application/xml,text/html, the content can be converted to a JSON string.
 * @property type
 */
public data class SyntheticTaskMonitorConfApiHttpRequestBodyArgs(
    public val content: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpRequestBodyArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpRequestBodyArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfApiHttpRequestBodyArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfApiHttpRequestBodyArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfApiHttpRequestBodyArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The request body content, in JSON string format. When the type is text/plain,application/json,application/xml,text/html, the content can be converted to a JSON string.
     */
    @JvmName("fftnebrghelibweh")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value
     */
    @JvmName("hbxquneedvvwiwit")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The request body content, in JSON string format. When the type is text/plain,application/json,application/xml,text/html, the content can be converted to a JSON string.
     */
    @JvmName("fylpilbeqmmovpgm")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value
     */
    @JvmName("tjfpnkfvdjwrucrk")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfApiHttpRequestBodyArgs =
        SyntheticTaskMonitorConfApiHttpRequestBodyArgs(
            content = content,
            type = type,
        )
}
