@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property apiHttp HTTP(S) task configuration information. See `api_http` below.
 * @property fileDownload File download type task configuration. See `file_download` below.
 * @property netDns The configuration parameters of the DNS dial test. Required when TaskType is 3. See `net_dns` below.
 * @property netIcmp ICMP dialing configuration parameters. Required when TaskType is 1. See `net_icmp` below.
 * @property netTcp The configuration parameters of TCP dial test. Required when TaskType is 2. See `net_tcp` below.
 * @property stream Streaming Media Dial Test Configuration. See `stream` below.
 * @property website Website speed measurement type task configuration. See `website` below.
 */
public data class SyntheticTaskMonitorConfArgs(
    public val apiHttp: Output<SyntheticTaskMonitorConfApiHttpArgs>? = null,
    public val fileDownload: Output<SyntheticTaskMonitorConfFileDownloadArgs>? = null,
    public val netDns: Output<SyntheticTaskMonitorConfNetDnsArgs>? = null,
    public val netIcmp: Output<SyntheticTaskMonitorConfNetIcmpArgs>? = null,
    public val netTcp: Output<SyntheticTaskMonitorConfNetTcpArgs>? = null,
    public val stream: Output<SyntheticTaskMonitorConfStreamArgs>? = null,
    public val website: Output<SyntheticTaskMonitorConfWebsiteArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfArgs.builder()
            .apiHttp(apiHttp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileDownload(fileDownload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .netDns(netDns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .netIcmp(netIcmp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .netTcp(netTcp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stream(stream?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .website(website?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfArgsBuilder internal constructor() {
    private var apiHttp: Output<SyntheticTaskMonitorConfApiHttpArgs>? = null

    private var fileDownload: Output<SyntheticTaskMonitorConfFileDownloadArgs>? = null

    private var netDns: Output<SyntheticTaskMonitorConfNetDnsArgs>? = null

    private var netIcmp: Output<SyntheticTaskMonitorConfNetIcmpArgs>? = null

    private var netTcp: Output<SyntheticTaskMonitorConfNetTcpArgs>? = null

    private var stream: Output<SyntheticTaskMonitorConfStreamArgs>? = null

    private var website: Output<SyntheticTaskMonitorConfWebsiteArgs>? = null

    /**
     * @param value HTTP(S) task configuration information. See `api_http` below.
     */
    @JvmName("rischisandrovjvw")
    public suspend fun apiHttp(`value`: Output<SyntheticTaskMonitorConfApiHttpArgs>) {
        this.apiHttp = value
    }

    /**
     * @param value File download type task configuration. See `file_download` below.
     */
    @JvmName("yorjvtqbnarthula")
    public suspend fun fileDownload(`value`: Output<SyntheticTaskMonitorConfFileDownloadArgs>) {
        this.fileDownload = value
    }

    /**
     * @param value The configuration parameters of the DNS dial test. Required when TaskType is 3. See `net_dns` below.
     */
    @JvmName("ibxbbrqrgptwiejr")
    public suspend fun netDns(`value`: Output<SyntheticTaskMonitorConfNetDnsArgs>) {
        this.netDns = value
    }

    /**
     * @param value ICMP dialing configuration parameters. Required when TaskType is 1. See `net_icmp` below.
     */
    @JvmName("ehdfedltxvynbhds")
    public suspend fun netIcmp(`value`: Output<SyntheticTaskMonitorConfNetIcmpArgs>) {
        this.netIcmp = value
    }

    /**
     * @param value The configuration parameters of TCP dial test. Required when TaskType is 2. See `net_tcp` below.
     */
    @JvmName("rvhgukmtnncirhfe")
    public suspend fun netTcp(`value`: Output<SyntheticTaskMonitorConfNetTcpArgs>) {
        this.netTcp = value
    }

    /**
     * @param value Streaming Media Dial Test Configuration. See `stream` below.
     */
    @JvmName("jvcohfvyuncndmbd")
    public suspend fun stream(`value`: Output<SyntheticTaskMonitorConfStreamArgs>) {
        this.stream = value
    }

    /**
     * @param value Website speed measurement type task configuration. See `website` below.
     */
    @JvmName("jdluxxrciaytgbxx")
    public suspend fun website(`value`: Output<SyntheticTaskMonitorConfWebsiteArgs>) {
        this.website = value
    }

    /**
     * @param value HTTP(S) task configuration information. See `api_http` below.
     */
    @JvmName("bgcnnxbmashaaduu")
    public suspend fun apiHttp(`value`: SyntheticTaskMonitorConfApiHttpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiHttp = mapped
    }

    /**
     * @param argument HTTP(S) task configuration information. See `api_http` below.
     */
    @JvmName("yrbhhgmfoseeyeyy")
    public suspend fun apiHttp(argument: suspend SyntheticTaskMonitorConfApiHttpArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfApiHttpArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiHttp = mapped
    }

    /**
     * @param value File download type task configuration. See `file_download` below.
     */
    @JvmName("ypvlleiuwywmkdgn")
    public suspend fun fileDownload(`value`: SyntheticTaskMonitorConfFileDownloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileDownload = mapped
    }

    /**
     * @param argument File download type task configuration. See `file_download` below.
     */
    @JvmName("jexpmbmebpkxbkvw")
    public suspend fun fileDownload(argument: suspend SyntheticTaskMonitorConfFileDownloadArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfFileDownloadArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fileDownload = mapped
    }

    /**
     * @param value The configuration parameters of the DNS dial test. Required when TaskType is 3. See `net_dns` below.
     */
    @JvmName("elsdqyydhxtqhuqo")
    public suspend fun netDns(`value`: SyntheticTaskMonitorConfNetDnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netDns = mapped
    }

    /**
     * @param argument The configuration parameters of the DNS dial test. Required when TaskType is 3. See `net_dns` below.
     */
    @JvmName("maxikvswrbdjoehd")
    public suspend fun netDns(argument: suspend SyntheticTaskMonitorConfNetDnsArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfNetDnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.netDns = mapped
    }

    /**
     * @param value ICMP dialing configuration parameters. Required when TaskType is 1. See `net_icmp` below.
     */
    @JvmName("tfxmuadhaqtoqrwk")
    public suspend fun netIcmp(`value`: SyntheticTaskMonitorConfNetIcmpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIcmp = mapped
    }

    /**
     * @param argument ICMP dialing configuration parameters. Required when TaskType is 1. See `net_icmp` below.
     */
    @JvmName("ochsqavlpdyxugyd")
    public suspend fun netIcmp(argument: suspend SyntheticTaskMonitorConfNetIcmpArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfNetIcmpArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.netIcmp = mapped
    }

    /**
     * @param value The configuration parameters of TCP dial test. Required when TaskType is 2. See `net_tcp` below.
     */
    @JvmName("hqqqbccllrjatume")
    public suspend fun netTcp(`value`: SyntheticTaskMonitorConfNetTcpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netTcp = mapped
    }

    /**
     * @param argument The configuration parameters of TCP dial test. Required when TaskType is 2. See `net_tcp` below.
     */
    @JvmName("onnybgjnnwnxmube")
    public suspend fun netTcp(argument: suspend SyntheticTaskMonitorConfNetTcpArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfNetTcpArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.netTcp = mapped
    }

    /**
     * @param value Streaming Media Dial Test Configuration. See `stream` below.
     */
    @JvmName("bticooawyyxnlysk")
    public suspend fun stream(`value`: SyntheticTaskMonitorConfStreamArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stream = mapped
    }

    /**
     * @param argument Streaming Media Dial Test Configuration. See `stream` below.
     */
    @JvmName("gusplcwbkgocoaah")
    public suspend fun stream(argument: suspend SyntheticTaskMonitorConfStreamArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfStreamArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stream = mapped
    }

    /**
     * @param value Website speed measurement type task configuration. See `website` below.
     */
    @JvmName("uxajpqtgvtuchvip")
    public suspend fun website(`value`: SyntheticTaskMonitorConfWebsiteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.website = mapped
    }

    /**
     * @param argument Website speed measurement type task configuration. See `website` below.
     */
    @JvmName("iphscyckuveiyhmo")
    public suspend fun website(argument: suspend SyntheticTaskMonitorConfWebsiteArgsBuilder.() -> Unit) {
        val toBeMapped = SyntheticTaskMonitorConfWebsiteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.website = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfArgs = SyntheticTaskMonitorConfArgs(
        apiHttp = apiHttp,
        fileDownload = fileDownload,
        netDns = netDns,
        netIcmp = netIcmp,
        netTcp = netTcp,
        stream = stream,
        website = website,
    )
}
