@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfFileDownloadArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property connectionTimeout Connection timeout time, in ms. Default 5000. Optional range: 1000-120000ms.
 * @property customHeaderContent Custom header, in JSON Map format.
 * @property downloadKernel Download the kernel.
 * - 1:curl
 * - 0:WinInet
 * Default 1.
 * @property ignoreCertificateAuthError Ignore CA Certificate authorization error 0: Do not ignore, 1: ignore, default 1.
 * @property ignoreCertificateCanceledError Ignore certificate revocation error 0: Do not ignore, 1: ignore, default 1.
 * @property ignoreCertificateOutOfDateError Ignore certificate expiration error 0: not ignored, 1: Ignored, default 1.
 * @property ignoreCertificateStatusError The certificate status error is ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
 * @property ignoreCertificateUntrustworthyError The certificate cannot be trusted and ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
 * @property ignoreCertificateUsingError Ignore certificate usage error 0: Do not ignore, 1: ignore, default 1.
 * @property ignoreInvalidHostError Invalid host error ignored, 0: not ignored, 1: Ignored, default 1.
 * @property monitorTimeout Monitoring timeout, in ms. Not required, 20000 by default.
 * @property quickProtocol Quick agreement
 * - 1:http1
 * - 2:http2
 * - 3:http3
 * Default 1.
 * @property redirection When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
 * @property targetUrl The target URL.
 * @property transmissionSize The transmission size, in KB. The default value is 2048KB. The transmission size of the downloaded file must be between 1 and 20480KB.
 * @property validateKeywords Verify keywords.
 * @property verifyWay The verification method.
 * - 0: Do not validate
 * - 1: Validation string
 * - 2:MD5 validation.
 * @property whiteList DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
 */
public data class SyntheticTaskMonitorConfFileDownloadArgs(
    public val connectionTimeout: Output<Int>? = null,
    public val customHeaderContent: Output<Map<String, String>>? = null,
    public val downloadKernel: Output<Int>? = null,
    public val ignoreCertificateAuthError: Output<Int>? = null,
    public val ignoreCertificateCanceledError: Output<Int>? = null,
    public val ignoreCertificateOutOfDateError: Output<Int>? = null,
    public val ignoreCertificateStatusError: Output<Int>? = null,
    public val ignoreCertificateUntrustworthyError: Output<Int>? = null,
    public val ignoreCertificateUsingError: Output<Int>? = null,
    public val ignoreInvalidHostError: Output<Int>? = null,
    public val monitorTimeout: Output<Int>? = null,
    public val quickProtocol: Output<Int>? = null,
    public val redirection: Output<Int>? = null,
    public val targetUrl: Output<String>,
    public val transmissionSize: Output<Int>? = null,
    public val validateKeywords: Output<String>? = null,
    public val verifyWay: Output<Int>? = null,
    public val whiteList: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfFileDownloadArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfFileDownloadArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfFileDownloadArgs.builder()
            .connectionTimeout(connectionTimeout?.applyValue({ args0 -> args0 }))
            .customHeaderContent(
                customHeaderContent?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .downloadKernel(downloadKernel?.applyValue({ args0 -> args0 }))
            .ignoreCertificateAuthError(ignoreCertificateAuthError?.applyValue({ args0 -> args0 }))
            .ignoreCertificateCanceledError(ignoreCertificateCanceledError?.applyValue({ args0 -> args0 }))
            .ignoreCertificateOutOfDateError(ignoreCertificateOutOfDateError?.applyValue({ args0 -> args0 }))
            .ignoreCertificateStatusError(ignoreCertificateStatusError?.applyValue({ args0 -> args0 }))
            .ignoreCertificateUntrustworthyError(
                ignoreCertificateUntrustworthyError?.applyValue({ args0 ->
                    args0
                }),
            )
            .ignoreCertificateUsingError(ignoreCertificateUsingError?.applyValue({ args0 -> args0 }))
            .ignoreInvalidHostError(ignoreInvalidHostError?.applyValue({ args0 -> args0 }))
            .monitorTimeout(monitorTimeout?.applyValue({ args0 -> args0 }))
            .quickProtocol(quickProtocol?.applyValue({ args0 -> args0 }))
            .redirection(redirection?.applyValue({ args0 -> args0 }))
            .targetUrl(targetUrl.applyValue({ args0 -> args0 }))
            .transmissionSize(transmissionSize?.applyValue({ args0 -> args0 }))
            .validateKeywords(validateKeywords?.applyValue({ args0 -> args0 }))
            .verifyWay(verifyWay?.applyValue({ args0 -> args0 }))
            .whiteList(whiteList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfFileDownloadArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfFileDownloadArgsBuilder internal constructor() {
    private var connectionTimeout: Output<Int>? = null

    private var customHeaderContent: Output<Map<String, String>>? = null

    private var downloadKernel: Output<Int>? = null

    private var ignoreCertificateAuthError: Output<Int>? = null

    private var ignoreCertificateCanceledError: Output<Int>? = null

    private var ignoreCertificateOutOfDateError: Output<Int>? = null

    private var ignoreCertificateStatusError: Output<Int>? = null

    private var ignoreCertificateUntrustworthyError: Output<Int>? = null

    private var ignoreCertificateUsingError: Output<Int>? = null

    private var ignoreInvalidHostError: Output<Int>? = null

    private var monitorTimeout: Output<Int>? = null

    private var quickProtocol: Output<Int>? = null

    private var redirection: Output<Int>? = null

    private var targetUrl: Output<String>? = null

    private var transmissionSize: Output<Int>? = null

    private var validateKeywords: Output<String>? = null

    private var verifyWay: Output<Int>? = null

    private var whiteList: Output<String>? = null

    /**
     * @param value Connection timeout time, in ms. Default 5000. Optional range: 1000-120000ms.
     */
    @JvmName("tjlhwbseyrjaogqd")
    public suspend fun connectionTimeout(`value`: Output<Int>) {
        this.connectionTimeout = value
    }

    /**
     * @param value Custom header, in JSON Map format.
     */
    @JvmName("obicekoqybbuucaw")
    public suspend fun customHeaderContent(`value`: Output<Map<String, String>>) {
        this.customHeaderContent = value
    }

    /**
     * @param value Download the kernel.
     * - 1:curl
     * - 0:WinInet
     * Default 1.
     */
    @JvmName("xwtyruklxuknddth")
    public suspend fun downloadKernel(`value`: Output<Int>) {
        this.downloadKernel = value
    }

    /**
     * @param value Ignore CA Certificate authorization error 0: Do not ignore, 1: ignore, default 1.
     */
    @JvmName("lcldhjdctsstbtrb")
    public suspend fun ignoreCertificateAuthError(`value`: Output<Int>) {
        this.ignoreCertificateAuthError = value
    }

    /**
     * @param value Ignore certificate revocation error 0: Do not ignore, 1: ignore, default 1.
     */
    @JvmName("ygaotrjxhnqebpyr")
    public suspend fun ignoreCertificateCanceledError(`value`: Output<Int>) {
        this.ignoreCertificateCanceledError = value
    }

    /**
     * @param value Ignore certificate expiration error 0: not ignored, 1: Ignored, default 1.
     */
    @JvmName("csbhgeqtpqskbqlt")
    public suspend fun ignoreCertificateOutOfDateError(`value`: Output<Int>) {
        this.ignoreCertificateOutOfDateError = value
    }

    /**
     * @param value The certificate status error is ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
     */
    @JvmName("pwujbrkcprottisx")
    public suspend fun ignoreCertificateStatusError(`value`: Output<Int>) {
        this.ignoreCertificateStatusError = value
    }

    /**
     * @param value The certificate cannot be trusted and ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
     */
    @JvmName("nagfwnjwskvnnwpx")
    public suspend fun ignoreCertificateUntrustworthyError(`value`: Output<Int>) {
        this.ignoreCertificateUntrustworthyError = value
    }

    /**
     * @param value Ignore certificate usage error 0: Do not ignore, 1: ignore, default 1.
     */
    @JvmName("fnrnfhnjeptqdses")
    public suspend fun ignoreCertificateUsingError(`value`: Output<Int>) {
        this.ignoreCertificateUsingError = value
    }

    /**
     * @param value Invalid host error ignored, 0: not ignored, 1: Ignored, default 1.
     */
    @JvmName("puvylcvcwgjmmsdd")
    public suspend fun ignoreInvalidHostError(`value`: Output<Int>) {
        this.ignoreInvalidHostError = value
    }

    /**
     * @param value Monitoring timeout, in ms. Not required, 20000 by default.
     */
    @JvmName("dkkgxswosjlplgtd")
    public suspend fun monitorTimeout(`value`: Output<Int>) {
        this.monitorTimeout = value
    }

    /**
     * @param value Quick agreement
     * - 1:http1
     * - 2:http2
     * - 3:http3
     * Default 1.
     */
    @JvmName("yklxyqerismoyahr")
    public suspend fun quickProtocol(`value`: Output<Int>) {
        this.quickProtocol = value
    }

    /**
     * @param value When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
     */
    @JvmName("knrnxrbyholhurbk")
    public suspend fun redirection(`value`: Output<Int>) {
        this.redirection = value
    }

    /**
     * @param value The target URL.
     */
    @JvmName("ixiowfnmhheuigfk")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value The transmission size, in KB. The default value is 2048KB. The transmission size of the downloaded file must be between 1 and 20480KB.
     */
    @JvmName("qlcklcbfchfmfdav")
    public suspend fun transmissionSize(`value`: Output<Int>) {
        this.transmissionSize = value
    }

    /**
     * @param value Verify keywords.
     */
    @JvmName("ygjlpkbjuioyilvc")
    public suspend fun validateKeywords(`value`: Output<String>) {
        this.validateKeywords = value
    }

    /**
     * @param value The verification method.
     * - 0: Do not validate
     * - 1: Validation string
     * - 2:MD5 validation.
     */
    @JvmName("jsvblsnlbiqiowcj")
    public suspend fun verifyWay(`value`: Output<Int>) {
        this.verifyWay = value
    }

    /**
     * @param value DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
     */
    @JvmName("cvoojisrgokjmdom")
    public suspend fun whiteList(`value`: Output<String>) {
        this.whiteList = value
    }

    /**
     * @param value Connection timeout time, in ms. Default 5000. Optional range: 1000-120000ms.
     */
    @JvmName("mxkvlbhfmsnikmil")
    public suspend fun connectionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTimeout = mapped
    }

    /**
     * @param value Custom header, in JSON Map format.
     */
    @JvmName("infwwaqglxjdtbxn")
    public suspend fun customHeaderContent(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaderContent = mapped
    }

    /**
     * @param values Custom header, in JSON Map format.
     */
    @JvmName("dwfgsdbtrftvrrld")
    public fun customHeaderContent(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaderContent = mapped
    }

    /**
     * @param value Download the kernel.
     * - 1:curl
     * - 0:WinInet
     * Default 1.
     */
    @JvmName("mxwxhgaqsvqavyok")
    public suspend fun downloadKernel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downloadKernel = mapped
    }

    /**
     * @param value Ignore CA Certificate authorization error 0: Do not ignore, 1: ignore, default 1.
     */
    @JvmName("rxdiapdimoxpgvpr")
    public suspend fun ignoreCertificateAuthError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCertificateAuthError = mapped
    }

    /**
     * @param value Ignore certificate revocation error 0: Do not ignore, 1: ignore, default 1.
     */
    @JvmName("qhqruclqpwgexxdd")
    public suspend fun ignoreCertificateCanceledError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCertificateCanceledError = mapped
    }

    /**
     * @param value Ignore certificate expiration error 0: not ignored, 1: Ignored, default 1.
     */
    @JvmName("caynxgkrqxicshse")
    public suspend fun ignoreCertificateOutOfDateError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCertificateOutOfDateError = mapped
    }

    /**
     * @param value The certificate status error is ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
     */
    @JvmName("npuenntqdeejkhea")
    public suspend fun ignoreCertificateStatusError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCertificateStatusError = mapped
    }

    /**
     * @param value The certificate cannot be trusted and ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
     */
    @JvmName("pdttbqyvfoldxvoo")
    public suspend fun ignoreCertificateUntrustworthyError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCertificateUntrustworthyError = mapped
    }

    /**
     * @param value Ignore certificate usage error 0: Do not ignore, 1: ignore, default 1.
     */
    @JvmName("imawiqbvkijxauhy")
    public suspend fun ignoreCertificateUsingError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCertificateUsingError = mapped
    }

    /**
     * @param value Invalid host error ignored, 0: not ignored, 1: Ignored, default 1.
     */
    @JvmName("qjbbprmgpqshyigv")
    public suspend fun ignoreInvalidHostError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreInvalidHostError = mapped
    }

    /**
     * @param value Monitoring timeout, in ms. Not required, 20000 by default.
     */
    @JvmName("edbpaetmpdohkink")
    public suspend fun monitorTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorTimeout = mapped
    }

    /**
     * @param value Quick agreement
     * - 1:http1
     * - 2:http2
     * - 3:http3
     * Default 1.
     */
    @JvmName("nbcdoqjxkvfusuaj")
    public suspend fun quickProtocol(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quickProtocol = mapped
    }

    /**
     * @param value When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
     */
    @JvmName("bxqshsduchjdrhek")
    public suspend fun redirection(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirection = mapped
    }

    /**
     * @param value The target URL.
     */
    @JvmName("svptkwavjeeelhjh")
    public suspend fun targetUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value The transmission size, in KB. The default value is 2048KB. The transmission size of the downloaded file must be between 1 and 20480KB.
     */
    @JvmName("ddmajmwdjjqyaanp")
    public suspend fun transmissionSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transmissionSize = mapped
    }

    /**
     * @param value Verify keywords.
     */
    @JvmName("lbqkeutbumiemicj")
    public suspend fun validateKeywords(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateKeywords = mapped
    }

    /**
     * @param value The verification method.
     * - 0: Do not validate
     * - 1: Validation string
     * - 2:MD5 validation.
     */
    @JvmName("sxnbuyekoooaapjb")
    public suspend fun verifyWay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyWay = mapped
    }

    /**
     * @param value DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
     */
    @JvmName("gmfawvauuderfjbr")
    public suspend fun whiteList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whiteList = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfFileDownloadArgs =
        SyntheticTaskMonitorConfFileDownloadArgs(
            connectionTimeout = connectionTimeout,
            customHeaderContent = customHeaderContent,
            downloadKernel = downloadKernel,
            ignoreCertificateAuthError = ignoreCertificateAuthError,
            ignoreCertificateCanceledError = ignoreCertificateCanceledError,
            ignoreCertificateOutOfDateError = ignoreCertificateOutOfDateError,
            ignoreCertificateStatusError = ignoreCertificateStatusError,
            ignoreCertificateUntrustworthyError = ignoreCertificateUntrustworthyError,
            ignoreCertificateUsingError = ignoreCertificateUsingError,
            ignoreInvalidHostError = ignoreInvalidHostError,
            monitorTimeout = monitorTimeout,
            quickProtocol = quickProtocol,
            redirection = redirection,
            targetUrl = targetUrl ?: throw PulumiNullFieldException("targetUrl"),
            transmissionSize = transmissionSize,
            validateKeywords = validateKeywords,
            verifyWay = verifyWay,
            whiteList = whiteList,
        )
}
