@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetDnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsServerIpType The IP address type of the DNS server.
 * - 0 (default):ipv4
 * - 1:ipv6
 * 2: Automatic.
 * @property nsServer The IP address of the NS server. The default value is 114.114.114.114.
 * @property queryMethod DNS query method.
 * - 0 (default): Recursive
 * - 1: Iteration.
 * @property targetUrl The target URL.
 * @property timeout TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
 */
public data class SyntheticTaskMonitorConfNetDnsArgs(
    public val dnsServerIpType: Output<Int>? = null,
    public val nsServer: Output<String>? = null,
    public val queryMethod: Output<Int>? = null,
    public val targetUrl: Output<String>,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetDnsArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetDnsArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetDnsArgs.builder()
            .dnsServerIpType(dnsServerIpType?.applyValue({ args0 -> args0 }))
            .nsServer(nsServer?.applyValue({ args0 -> args0 }))
            .queryMethod(queryMethod?.applyValue({ args0 -> args0 }))
            .targetUrl(targetUrl.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfNetDnsArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfNetDnsArgsBuilder internal constructor() {
    private var dnsServerIpType: Output<Int>? = null

    private var nsServer: Output<String>? = null

    private var queryMethod: Output<Int>? = null

    private var targetUrl: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value The IP address type of the DNS server.
     * - 0 (default):ipv4
     * - 1:ipv6
     * 2: Automatic.
     */
    @JvmName("drbjceyjmggyiqqk")
    public suspend fun dnsServerIpType(`value`: Output<Int>) {
        this.dnsServerIpType = value
    }

    /**
     * @param value The IP address of the NS server. The default value is 114.114.114.114.
     */
    @JvmName("hktrgajcjbwjadvi")
    public suspend fun nsServer(`value`: Output<String>) {
        this.nsServer = value
    }

    /**
     * @param value DNS query method.
     * - 0 (default): Recursive
     * - 1: Iteration.
     */
    @JvmName("wcuyucuqpphnipbr")
    public suspend fun queryMethod(`value`: Output<Int>) {
        this.queryMethod = value
    }

    /**
     * @param value The target URL.
     */
    @JvmName("jfpbbgsltkphvhxq")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("swychfvfguxokuqy")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The IP address type of the DNS server.
     * - 0 (default):ipv4
     * - 1:ipv6
     * 2: Automatic.
     */
    @JvmName("ymbgsfsnsiyyujtw")
    public suspend fun dnsServerIpType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServerIpType = mapped
    }

    /**
     * @param value The IP address of the NS server. The default value is 114.114.114.114.
     */
    @JvmName("jtnecybluydrewwb")
    public suspend fun nsServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nsServer = mapped
    }

    /**
     * @param value DNS query method.
     * - 0 (default): Recursive
     * - 1: Iteration.
     */
    @JvmName("eeryljufkwhfmwyp")
    public suspend fun queryMethod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryMethod = mapped
    }

    /**
     * @param value The target URL.
     */
    @JvmName("pbullklqrkdigope")
    public suspend fun targetUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("mmedahlhidgauvlc")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfNetDnsArgs = SyntheticTaskMonitorConfNetDnsArgs(
        dnsServerIpType = dnsServerIpType,
        nsServer = nsServer,
        queryMethod = queryMethod,
        targetUrl = targetUrl ?: throw PulumiNullFieldException("targetUrl"),
        timeout = timeout,
    )
}
