@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetIcmpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property interval The interval between TCP connections. The unit is milliseconds (ms), the minimum value is 200, the maximum value is 10000, and the default value is 200.
 * @property packageNum Number of ICMP(Ping) packets sent. The minimum value is 1, the maximum value is 50, and the default is 4.
 * @property packageSize The size of the sent ICMP(Ping) packet. The unit is byte. The ICMP(PING) packet size is limited to 32, 64, 128, 256, 512, 1024, 1080, and 1450.
 * @property splitPackage Whether to split ICMP(Ping) packets. The default is true.
 * @property targetUrl The target URL.
 * @property timeout TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
 * @property tracertEnable Whether to enable tracert. The default is true.
 * @property tracertNumMax The maximum number of hops for tracert. The minimum value is 1, the maximum value is 128, and the default value is 20.
 * @property tracertTimeout The time-out of tracert. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 60000.
 */
public data class SyntheticTaskMonitorConfNetIcmpArgs(
    public val interval: Output<Int>? = null,
    public val packageNum: Output<Int>? = null,
    public val packageSize: Output<Int>? = null,
    public val splitPackage: Output<Boolean>? = null,
    public val targetUrl: Output<String>,
    public val timeout: Output<Int>? = null,
    public val tracertEnable: Output<Boolean>? = null,
    public val tracertNumMax: Output<Int>? = null,
    public val tracertTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetIcmpArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetIcmpArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetIcmpArgs.builder()
            .interval(interval?.applyValue({ args0 -> args0 }))
            .packageNum(packageNum?.applyValue({ args0 -> args0 }))
            .packageSize(packageSize?.applyValue({ args0 -> args0 }))
            .splitPackage(splitPackage?.applyValue({ args0 -> args0 }))
            .targetUrl(targetUrl.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .tracertEnable(tracertEnable?.applyValue({ args0 -> args0 }))
            .tracertNumMax(tracertNumMax?.applyValue({ args0 -> args0 }))
            .tracertTimeout(tracertTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfNetIcmpArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfNetIcmpArgsBuilder internal constructor() {
    private var interval: Output<Int>? = null

    private var packageNum: Output<Int>? = null

    private var packageSize: Output<Int>? = null

    private var splitPackage: Output<Boolean>? = null

    private var targetUrl: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var tracertEnable: Output<Boolean>? = null

    private var tracertNumMax: Output<Int>? = null

    private var tracertTimeout: Output<Int>? = null

    /**
     * @param value The interval between TCP connections. The unit is milliseconds (ms), the minimum value is 200, the maximum value is 10000, and the default value is 200.
     */
    @JvmName("lgvxlvpwyhapihpm")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Number of ICMP(Ping) packets sent. The minimum value is 1, the maximum value is 50, and the default is 4.
     */
    @JvmName("tvvydnkyvcrfrvrh")
    public suspend fun packageNum(`value`: Output<Int>) {
        this.packageNum = value
    }

    /**
     * @param value The size of the sent ICMP(Ping) packet. The unit is byte. The ICMP(PING) packet size is limited to 32, 64, 128, 256, 512, 1024, 1080, and 1450.
     */
    @JvmName("tmysiqcklgalystf")
    public suspend fun packageSize(`value`: Output<Int>) {
        this.packageSize = value
    }

    /**
     * @param value Whether to split ICMP(Ping) packets. The default is true.
     */
    @JvmName("pmipfxqdojigfnpc")
    public suspend fun splitPackage(`value`: Output<Boolean>) {
        this.splitPackage = value
    }

    /**
     * @param value The target URL.
     */
    @JvmName("dkexsuouxhnvuawy")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("tknscfstopkktwoy")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Whether to enable tracert. The default is true.
     */
    @JvmName("coqugqvpqjddkbeo")
    public suspend fun tracertEnable(`value`: Output<Boolean>) {
        this.tracertEnable = value
    }

    /**
     * @param value The maximum number of hops for tracert. The minimum value is 1, the maximum value is 128, and the default value is 20.
     */
    @JvmName("xlfqqwlydpviarfy")
    public suspend fun tracertNumMax(`value`: Output<Int>) {
        this.tracertNumMax = value
    }

    /**
     * @param value The time-out of tracert. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 60000.
     */
    @JvmName("bgxfqtskcyeeuggc")
    public suspend fun tracertTimeout(`value`: Output<Int>) {
        this.tracertTimeout = value
    }

    /**
     * @param value The interval between TCP connections. The unit is milliseconds (ms), the minimum value is 200, the maximum value is 10000, and the default value is 200.
     */
    @JvmName("cxdeseivfvyvbjjn")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Number of ICMP(Ping) packets sent. The minimum value is 1, the maximum value is 50, and the default is 4.
     */
    @JvmName("olklmqjqiuvhphdt")
    public suspend fun packageNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageNum = mapped
    }

    /**
     * @param value The size of the sent ICMP(Ping) packet. The unit is byte. The ICMP(PING) packet size is limited to 32, 64, 128, 256, 512, 1024, 1080, and 1450.
     */
    @JvmName("tmqdtxomakxvxpan")
    public suspend fun packageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageSize = mapped
    }

    /**
     * @param value Whether to split ICMP(Ping) packets. The default is true.
     */
    @JvmName("jlcgguvxgxxhtfow")
    public suspend fun splitPackage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.splitPackage = mapped
    }

    /**
     * @param value The target URL.
     */
    @JvmName("upwmkjrodpfxbfir")
    public suspend fun targetUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("fbsivngjxofyshid")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Whether to enable tracert. The default is true.
     */
    @JvmName("mvhvygeshgutwekb")
    public suspend fun tracertEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracertEnable = mapped
    }

    /**
     * @param value The maximum number of hops for tracert. The minimum value is 1, the maximum value is 128, and the default value is 20.
     */
    @JvmName("nrreuffpthgoorst")
    public suspend fun tracertNumMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracertNumMax = mapped
    }

    /**
     * @param value The time-out of tracert. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 60000.
     */
    @JvmName("bmlxwffwiwosykel")
    public suspend fun tracertTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracertTimeout = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfNetIcmpArgs = SyntheticTaskMonitorConfNetIcmpArgs(
        interval = interval,
        packageNum = packageNum,
        packageSize = packageSize,
        splitPackage = splitPackage,
        targetUrl = targetUrl ?: throw PulumiNullFieldException("targetUrl"),
        timeout = timeout,
        tracertEnable = tracertEnable,
        tracertNumMax = tracertNumMax,
        tracertTimeout = tracertTimeout,
    )
}
