@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetTcpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectTimes The number of TCP connections established. The minimum value is 1, the maximum value is 16, and the default is 4.
 * @property interval The interval between TCP connections. The unit is milliseconds (ms), the minimum value is 200, the maximum value is 10000, and the default value is 200.
 * @property targetUrl The target URL.
 * @property timeout TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
 * @property tracertEnable Whether to enable tracert. The default is true.
 * @property tracertNumMax The maximum number of hops for tracert. The minimum value is 1, the maximum value is 128, and the default value is 20.
 * @property tracertTimeout The time-out of tracert. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 60000.
 */
public data class SyntheticTaskMonitorConfNetTcpArgs(
    public val connectTimes: Output<Int>? = null,
    public val interval: Output<Int>? = null,
    public val targetUrl: Output<String>,
    public val timeout: Output<Int>? = null,
    public val tracertEnable: Output<Boolean>? = null,
    public val tracertNumMax: Output<Int>? = null,
    public val tracertTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetTcpArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetTcpArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfNetTcpArgs.builder()
            .connectTimes(connectTimes?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .targetUrl(targetUrl.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .tracertEnable(tracertEnable?.applyValue({ args0 -> args0 }))
            .tracertNumMax(tracertNumMax?.applyValue({ args0 -> args0 }))
            .tracertTimeout(tracertTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfNetTcpArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfNetTcpArgsBuilder internal constructor() {
    private var connectTimes: Output<Int>? = null

    private var interval: Output<Int>? = null

    private var targetUrl: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var tracertEnable: Output<Boolean>? = null

    private var tracertNumMax: Output<Int>? = null

    private var tracertTimeout: Output<Int>? = null

    /**
     * @param value The number of TCP connections established. The minimum value is 1, the maximum value is 16, and the default is 4.
     */
    @JvmName("pgdxubdinhimsjjn")
    public suspend fun connectTimes(`value`: Output<Int>) {
        this.connectTimes = value
    }

    /**
     * @param value The interval between TCP connections. The unit is milliseconds (ms), the minimum value is 200, the maximum value is 10000, and the default value is 200.
     */
    @JvmName("dvcvtwoexnfmwirr")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The target URL.
     */
    @JvmName("sfgnsitmeiemkqoc")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("eccklivkxsmjrggq")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Whether to enable tracert. The default is true.
     */
    @JvmName("vusapqemikjveogb")
    public suspend fun tracertEnable(`value`: Output<Boolean>) {
        this.tracertEnable = value
    }

    /**
     * @param value The maximum number of hops for tracert. The minimum value is 1, the maximum value is 128, and the default value is 20.
     */
    @JvmName("ptcbnkkrjxlwlohn")
    public suspend fun tracertNumMax(`value`: Output<Int>) {
        this.tracertNumMax = value
    }

    /**
     * @param value The time-out of tracert. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 60000.
     */
    @JvmName("cnsvpqrquexyldwg")
    public suspend fun tracertTimeout(`value`: Output<Int>) {
        this.tracertTimeout = value
    }

    /**
     * @param value The number of TCP connections established. The minimum value is 1, the maximum value is 16, and the default is 4.
     */
    @JvmName("umaavgokavyooupx")
    public suspend fun connectTimes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectTimes = mapped
    }

    /**
     * @param value The interval between TCP connections. The unit is milliseconds (ms), the minimum value is 200, the maximum value is 10000, and the default value is 200.
     */
    @JvmName("xkvtonqxiqqgiooj")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The target URL.
     */
    @JvmName("ukmlgermqeutqlxx")
    public suspend fun targetUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
     */
    @JvmName("siuhiosicemadqck")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Whether to enable tracert. The default is true.
     */
    @JvmName("mxmtbsgnhoyftywr")
    public suspend fun tracertEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracertEnable = mapped
    }

    /**
     * @param value The maximum number of hops for tracert. The minimum value is 1, the maximum value is 128, and the default value is 20.
     */
    @JvmName("oxpxmseptootiolb")
    public suspend fun tracertNumMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracertNumMax = mapped
    }

    /**
     * @param value The time-out of tracert. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 60000.
     */
    @JvmName("kukgtrmqjfipixfb")
    public suspend fun tracertTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracertTimeout = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfNetTcpArgs = SyntheticTaskMonitorConfNetTcpArgs(
        connectTimes = connectTimes,
        interval = interval,
        targetUrl = targetUrl ?: throw PulumiNullFieldException("targetUrl"),
        timeout = timeout,
        tracertEnable = tracertEnable,
        tracertNumMax = tracertNumMax,
        tracertTimeout = tracertTimeout,
    )
}
