@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property customHeaderContent Custom header, in JSON Map format.
 * @property playerType Player, do not pass the default 12.
 * - 12:VLC
 * - 2:FlashPlayer.
 * @property streamAddressType Resource address type:
 * - 1: Resource address.
 * - 0: page address, not 0 by default.
 * @property streamMonitorTimeout Monitoring duration, in seconds, up to 60s, not 60 by default.
 * @property streamType Audio and video flags: 0-video, 1-audio.
 * @property targetUrl The target URL.
 * @property whiteList DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
 */
public data class SyntheticTaskMonitorConfStreamArgs(
    public val customHeaderContent: Output<Map<String, String>>? = null,
    public val playerType: Output<Int>? = null,
    public val streamAddressType: Output<Int>? = null,
    public val streamMonitorTimeout: Output<Int>? = null,
    public val streamType: Output<Int>? = null,
    public val targetUrl: Output<String>? = null,
    public val whiteList: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfStreamArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfStreamArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfStreamArgs.builder()
            .customHeaderContent(
                customHeaderContent?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .playerType(playerType?.applyValue({ args0 -> args0 }))
            .streamAddressType(streamAddressType?.applyValue({ args0 -> args0 }))
            .streamMonitorTimeout(streamMonitorTimeout?.applyValue({ args0 -> args0 }))
            .streamType(streamType?.applyValue({ args0 -> args0 }))
            .targetUrl(targetUrl?.applyValue({ args0 -> args0 }))
            .whiteList(whiteList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfStreamArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfStreamArgsBuilder internal constructor() {
    private var customHeaderContent: Output<Map<String, String>>? = null

    private var playerType: Output<Int>? = null

    private var streamAddressType: Output<Int>? = null

    private var streamMonitorTimeout: Output<Int>? = null

    private var streamType: Output<Int>? = null

    private var targetUrl: Output<String>? = null

    private var whiteList: Output<String>? = null

    /**
     * @param value Custom header, in JSON Map format.
     */
    @JvmName("dryxkxtagoqdwbxd")
    public suspend fun customHeaderContent(`value`: Output<Map<String, String>>) {
        this.customHeaderContent = value
    }

    /**
     * @param value Player, do not pass the default 12.
     * - 12:VLC
     * - 2:FlashPlayer.
     */
    @JvmName("luynpronuacsfpct")
    public suspend fun playerType(`value`: Output<Int>) {
        this.playerType = value
    }

    /**
     * @param value Resource address type:
     * - 1: Resource address.
     * - 0: page address, not 0 by default.
     */
    @JvmName("pabcbipjscowdach")
    public suspend fun streamAddressType(`value`: Output<Int>) {
        this.streamAddressType = value
    }

    /**
     * @param value Monitoring duration, in seconds, up to 60s, not 60 by default.
     */
    @JvmName("lawmwsrqurdebloo")
    public suspend fun streamMonitorTimeout(`value`: Output<Int>) {
        this.streamMonitorTimeout = value
    }

    /**
     * @param value Audio and video flags: 0-video, 1-audio.
     */
    @JvmName("nwomcdauidkmiqil")
    public suspend fun streamType(`value`: Output<Int>) {
        this.streamType = value
    }

    /**
     * @param value The target URL.
     */
    @JvmName("lgkebexgukpljffx")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
     */
    @JvmName("ealxhprsviyvdxto")
    public suspend fun whiteList(`value`: Output<String>) {
        this.whiteList = value
    }

    /**
     * @param value Custom header, in JSON Map format.
     */
    @JvmName("dvsqqicehoetstin")
    public suspend fun customHeaderContent(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaderContent = mapped
    }

    /**
     * @param values Custom header, in JSON Map format.
     */
    @JvmName("nuceteswejimvvrq")
    public fun customHeaderContent(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaderContent = mapped
    }

    /**
     * @param value Player, do not pass the default 12.
     * - 12:VLC
     * - 2:FlashPlayer.
     */
    @JvmName("njjrmfrhrxtyosec")
    public suspend fun playerType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playerType = mapped
    }

    /**
     * @param value Resource address type:
     * - 1: Resource address.
     * - 0: page address, not 0 by default.
     */
    @JvmName("xdywfhecibdquidg")
    public suspend fun streamAddressType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamAddressType = mapped
    }

    /**
     * @param value Monitoring duration, in seconds, up to 60s, not 60 by default.
     */
    @JvmName("igkptqooweecodof")
    public suspend fun streamMonitorTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamMonitorTimeout = mapped
    }

    /**
     * @param value Audio and video flags: 0-video, 1-audio.
     */
    @JvmName("hmwirpvtklgerppi")
    public suspend fun streamType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamType = mapped
    }

    /**
     * @param value The target URL.
     */
    @JvmName("cgciijommxcxjwob")
    public suspend fun targetUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
     */
    @JvmName("omllijjncvjgfhky")
    public suspend fun whiteList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whiteList = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfStreamArgs = SyntheticTaskMonitorConfStreamArgs(
        customHeaderContent = customHeaderContent,
        playerType = playerType,
        streamAddressType = streamAddressType,
        streamMonitorTimeout = streamMonitorTimeout,
        streamType = streamType,
        targetUrl = targetUrl,
        whiteList = whiteList,
    )
}
