@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.inputs

import com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfWebsiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property automaticScrolling Whether to support automatic scrolling screen, loading page.
 * - 0 (default): No
 * 1: Yes.
 * @property customHeader Custom header.
 * - 0 (default): Off
 * - 1: Modify the first package
 * - 2: Modify all packages.
 * @property customHeaderContent Custom header, in JSON Map format.
 * @property disableCache Whether to disable caching.
 * - 0: not disabled
 * - 1 (default): Disabled.
 * @property disableCompression The Accept-Encoding field is used to determine whether to Accept compressed files. 0-do not disable, 1-disable, the default is 0.
 * @property dnsHijackWhitelist When a domain name (such as www.aliyun.com) is resolved, if the resolved IP address or CNAME is not in the DNS hijacking white list, the user will fail to access or return a target IP address that is not Aliyun. If the IP or CNAME in the resolution result is in the DNS white list, it will be determined that DNS hijacking has not occurred.  Fill in the format: Domain name: matching rules. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
 * @property elementBlacklist If an element configured in the element blacklist appears during page loading, the element is not requested to be loaded.
 * @property filterInvalidIp Whether to filter invalid IP parameters. 0: filter, 1: do not filter. The default value is 0.
 * @property flowHijackJumpTimes Identify elements: Set the total number of elements on the Browse page.
 * @property flowHijackLogo Hijacking ID: Set the matching key information. Enter the hijacking keyword or key element, with an asterisk (*) allowed.
 * @property ignoreCertificateError Whether to ignore certificate errors during certificate verification in SSL Handshake and continue browsing. 0-do not ignore, 1-ignore. The default value is 1.
 * @property monitorTimeout Monitoring timeout, in ms. Not required, 20000 by default.
 * @property pageTamper Monitoring the page appears to be tampered with elements other than the domain settings that belong to the page. Common manifestations are pop-up advertisements, floating advertisements, jumps, etc.  Fill in the format: Domain name: Element. You can fill multiple elements separated by a vertical bar (|). For example, www.aliyun.com:|/cc/bb/a.gif |/vv/bb/cc.jpg indicates that all the other elements of the www.aliyun.com domain name except the basic document,/cc/bb/a.gif, and/vv/bb/cc.jpg are tampered.
 * @property redirection When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
 * @property slowElementThreshold The slow element threshold, in ms, is 5000 by default and can be selected from 1 to 300000ms.
 * @property targetUrl The target URL.
 * @property verifyStringBlacklist The verification string is an arbitrary string in the source code of the monitoring page. If the source code returned by the client contains any of the blacklisted strings, 650 error is returned. Multiple strings are separated by a vertical bar (|).
 * @property verifyStringWhitelist The verification string is an arbitrary string in the source code of the monitoring page. The source code returned by the client must contain all the strings in the whitelist. Otherwise, 650 error is returned. Multiple strings are separated by a vertical bar (|).
 * @property waitCompletionTime The maximum waiting time, in ms, is 5000 by default and can be selected from 5000 ms to 300000ms.
 */
public data class SyntheticTaskMonitorConfWebsiteArgs(
    public val automaticScrolling: Output<Int>? = null,
    public val customHeader: Output<Int>? = null,
    public val customHeaderContent: Output<Map<String, String>>? = null,
    public val disableCache: Output<Int>? = null,
    public val disableCompression: Output<Int>? = null,
    public val dnsHijackWhitelist: Output<String>? = null,
    public val elementBlacklist: Output<String>? = null,
    public val filterInvalidIp: Output<Int>? = null,
    public val flowHijackJumpTimes: Output<Int>? = null,
    public val flowHijackLogo: Output<String>? = null,
    public val ignoreCertificateError: Output<Int>? = null,
    public val monitorTimeout: Output<Int>? = null,
    public val pageTamper: Output<String>? = null,
    public val redirection: Output<Int>? = null,
    public val slowElementThreshold: Output<Int>? = null,
    public val targetUrl: Output<String>,
    public val verifyStringBlacklist: Output<String>? = null,
    public val verifyStringWhitelist: Output<String>? = null,
    public val waitCompletionTime: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfWebsiteArgs> {
    override fun toJava(): com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfWebsiteArgs =
        com.pulumi.alicloud.arms.inputs.SyntheticTaskMonitorConfWebsiteArgs.builder()
            .automaticScrolling(automaticScrolling?.applyValue({ args0 -> args0 }))
            .customHeader(customHeader?.applyValue({ args0 -> args0 }))
            .customHeaderContent(
                customHeaderContent?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .disableCache(disableCache?.applyValue({ args0 -> args0 }))
            .disableCompression(disableCompression?.applyValue({ args0 -> args0 }))
            .dnsHijackWhitelist(dnsHijackWhitelist?.applyValue({ args0 -> args0 }))
            .elementBlacklist(elementBlacklist?.applyValue({ args0 -> args0 }))
            .filterInvalidIp(filterInvalidIp?.applyValue({ args0 -> args0 }))
            .flowHijackJumpTimes(flowHijackJumpTimes?.applyValue({ args0 -> args0 }))
            .flowHijackLogo(flowHijackLogo?.applyValue({ args0 -> args0 }))
            .ignoreCertificateError(ignoreCertificateError?.applyValue({ args0 -> args0 }))
            .monitorTimeout(monitorTimeout?.applyValue({ args0 -> args0 }))
            .pageTamper(pageTamper?.applyValue({ args0 -> args0 }))
            .redirection(redirection?.applyValue({ args0 -> args0 }))
            .slowElementThreshold(slowElementThreshold?.applyValue({ args0 -> args0 }))
            .targetUrl(targetUrl.applyValue({ args0 -> args0 }))
            .verifyStringBlacklist(verifyStringBlacklist?.applyValue({ args0 -> args0 }))
            .verifyStringWhitelist(verifyStringWhitelist?.applyValue({ args0 -> args0 }))
            .waitCompletionTime(waitCompletionTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyntheticTaskMonitorConfWebsiteArgs].
 */
@PulumiTagMarker
public class SyntheticTaskMonitorConfWebsiteArgsBuilder internal constructor() {
    private var automaticScrolling: Output<Int>? = null

    private var customHeader: Output<Int>? = null

    private var customHeaderContent: Output<Map<String, String>>? = null

    private var disableCache: Output<Int>? = null

    private var disableCompression: Output<Int>? = null

    private var dnsHijackWhitelist: Output<String>? = null

    private var elementBlacklist: Output<String>? = null

    private var filterInvalidIp: Output<Int>? = null

    private var flowHijackJumpTimes: Output<Int>? = null

    private var flowHijackLogo: Output<String>? = null

    private var ignoreCertificateError: Output<Int>? = null

    private var monitorTimeout: Output<Int>? = null

    private var pageTamper: Output<String>? = null

    private var redirection: Output<Int>? = null

    private var slowElementThreshold: Output<Int>? = null

    private var targetUrl: Output<String>? = null

    private var verifyStringBlacklist: Output<String>? = null

    private var verifyStringWhitelist: Output<String>? = null

    private var waitCompletionTime: Output<Int>? = null

    /**
     * @param value Whether to support automatic scrolling screen, loading page.
     * - 0 (default): No
     * 1: Yes.
     */
    @JvmName("sgnsqwalkobiwuqm")
    public suspend fun automaticScrolling(`value`: Output<Int>) {
        this.automaticScrolling = value
    }

    /**
     * @param value Custom header.
     * - 0 (default): Off
     * - 1: Modify the first package
     * - 2: Modify all packages.
     */
    @JvmName("byveamrnocksardy")
    public suspend fun customHeader(`value`: Output<Int>) {
        this.customHeader = value
    }

    /**
     * @param value Custom header, in JSON Map format.
     */
    @JvmName("wvpqkuqcqckbmnkf")
    public suspend fun customHeaderContent(`value`: Output<Map<String, String>>) {
        this.customHeaderContent = value
    }

    /**
     * @param value Whether to disable caching.
     * - 0: not disabled
     * - 1 (default): Disabled.
     */
    @JvmName("rnsnlporaexglatm")
    public suspend fun disableCache(`value`: Output<Int>) {
        this.disableCache = value
    }

    /**
     * @param value The Accept-Encoding field is used to determine whether to Accept compressed files. 0-do not disable, 1-disable, the default is 0.
     */
    @JvmName("lpippjqdsufkewhc")
    public suspend fun disableCompression(`value`: Output<Int>) {
        this.disableCompression = value
    }

    /**
     * @param value When a domain name (such as www.aliyun.com) is resolved, if the resolved IP address or CNAME is not in the DNS hijacking white list, the user will fail to access or return a target IP address that is not Aliyun. If the IP or CNAME in the resolution result is in the DNS white list, it will be determined that DNS hijacking has not occurred.  Fill in the format: Domain name: matching rules. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
     */
    @JvmName("bouqvwcdsrkfaohg")
    public suspend fun dnsHijackWhitelist(`value`: Output<String>) {
        this.dnsHijackWhitelist = value
    }

    /**
     * @param value If an element configured in the element blacklist appears during page loading, the element is not requested to be loaded.
     */
    @JvmName("pldviunhmwodardc")
    public suspend fun elementBlacklist(`value`: Output<String>) {
        this.elementBlacklist = value
    }

    /**
     * @param value Whether to filter invalid IP parameters. 0: filter, 1: do not filter. The default value is 0.
     */
    @JvmName("gmunqfssivvxihkn")
    public suspend fun filterInvalidIp(`value`: Output<Int>) {
        this.filterInvalidIp = value
    }

    /**
     * @param value Identify elements: Set the total number of elements on the Browse page.
     */
    @JvmName("yuansnjiwbffmevc")
    public suspend fun flowHijackJumpTimes(`value`: Output<Int>) {
        this.flowHijackJumpTimes = value
    }

    /**
     * @param value Hijacking ID: Set the matching key information. Enter the hijacking keyword or key element, with an asterisk (*) allowed.
     */
    @JvmName("gaerymvdnpgusovq")
    public suspend fun flowHijackLogo(`value`: Output<String>) {
        this.flowHijackLogo = value
    }

    /**
     * @param value Whether to ignore certificate errors during certificate verification in SSL Handshake and continue browsing. 0-do not ignore, 1-ignore. The default value is 1.
     */
    @JvmName("tocgevvhqkcghdhj")
    public suspend fun ignoreCertificateError(`value`: Output<Int>) {
        this.ignoreCertificateError = value
    }

    /**
     * @param value Monitoring timeout, in ms. Not required, 20000 by default.
     */
    @JvmName("ngatglpdydsionyf")
    public suspend fun monitorTimeout(`value`: Output<Int>) {
        this.monitorTimeout = value
    }

    /**
     * @param value Monitoring the page appears to be tampered with elements other than the domain settings that belong to the page. Common manifestations are pop-up advertisements, floating advertisements, jumps, etc.  Fill in the format: Domain name: Element. You can fill multiple elements separated by a vertical bar (|). For example, www.aliyun.com:|/cc/bb/a.gif |/vv/bb/cc.jpg indicates that all the other elements of the www.aliyun.com domain name except the basic document,/cc/bb/a.gif, and/vv/bb/cc.jpg are tampered.
     */
    @JvmName("ceivbykhwnasggpn")
    public suspend fun pageTamper(`value`: Output<String>) {
        this.pageTamper = value
    }

    /**
     * @param value When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
     */
    @JvmName("bdacbhhsgccshkvt")
    public suspend fun redirection(`value`: Output<Int>) {
        this.redirection = value
    }

    /**
     * @param value The slow element threshold, in ms, is 5000 by default and can be selected from 1 to 300000ms.
     */
    @JvmName("lpnulqtbribwiwjx")
    public suspend fun slowElementThreshold(`value`: Output<Int>) {
        this.slowElementThreshold = value
    }

    /**
     * @param value The target URL.
     */
    @JvmName("rxmjykdgpcvstoej")
    public suspend fun targetUrl(`value`: Output<String>) {
        this.targetUrl = value
    }

    /**
     * @param value The verification string is an arbitrary string in the source code of the monitoring page. If the source code returned by the client contains any of the blacklisted strings, 650 error is returned. Multiple strings are separated by a vertical bar (|).
     */
    @JvmName("iwjksydrovwpotut")
    public suspend fun verifyStringBlacklist(`value`: Output<String>) {
        this.verifyStringBlacklist = value
    }

    /**
     * @param value The verification string is an arbitrary string in the source code of the monitoring page. The source code returned by the client must contain all the strings in the whitelist. Otherwise, 650 error is returned. Multiple strings are separated by a vertical bar (|).
     */
    @JvmName("geimyydvkalwdndl")
    public suspend fun verifyStringWhitelist(`value`: Output<String>) {
        this.verifyStringWhitelist = value
    }

    /**
     * @param value The maximum waiting time, in ms, is 5000 by default and can be selected from 5000 ms to 300000ms.
     */
    @JvmName("qfixayabtkiydbrs")
    public suspend fun waitCompletionTime(`value`: Output<Int>) {
        this.waitCompletionTime = value
    }

    /**
     * @param value Whether to support automatic scrolling screen, loading page.
     * - 0 (default): No
     * 1: Yes.
     */
    @JvmName("xcmaawykbivrnhen")
    public suspend fun automaticScrolling(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticScrolling = mapped
    }

    /**
     * @param value Custom header.
     * - 0 (default): Off
     * - 1: Modify the first package
     * - 2: Modify all packages.
     */
    @JvmName("kenwpodnhtikiqxr")
    public suspend fun customHeader(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeader = mapped
    }

    /**
     * @param value Custom header, in JSON Map format.
     */
    @JvmName("pbopgorruooilrpj")
    public suspend fun customHeaderContent(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaderContent = mapped
    }

    /**
     * @param values Custom header, in JSON Map format.
     */
    @JvmName("frbvftpvhqfelsgu")
    public fun customHeaderContent(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaderContent = mapped
    }

    /**
     * @param value Whether to disable caching.
     * - 0: not disabled
     * - 1 (default): Disabled.
     */
    @JvmName("tpylwlvqrlhylmdl")
    public suspend fun disableCache(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableCache = mapped
    }

    /**
     * @param value The Accept-Encoding field is used to determine whether to Accept compressed files. 0-do not disable, 1-disable, the default is 0.
     */
    @JvmName("yxdksqnxcfpbrsbi")
    public suspend fun disableCompression(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableCompression = mapped
    }

    /**
     * @param value When a domain name (such as www.aliyun.com) is resolved, if the resolved IP address or CNAME is not in the DNS hijacking white list, the user will fail to access or return a target IP address that is not Aliyun. If the IP or CNAME in the resolution result is in the DNS white list, it will be determined that DNS hijacking has not occurred.  Fill in the format: Domain name: matching rules. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
     */
    @JvmName("dvqdjnnbiatmquer")
    public suspend fun dnsHijackWhitelist(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsHijackWhitelist = mapped
    }

    /**
     * @param value If an element configured in the element blacklist appears during page loading, the element is not requested to be loaded.
     */
    @JvmName("tdibvexorkearsig")
    public suspend fun elementBlacklist(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elementBlacklist = mapped
    }

    /**
     * @param value Whether to filter invalid IP parameters. 0: filter, 1: do not filter. The default value is 0.
     */
    @JvmName("kkwcfwcdrcmnamxl")
    public suspend fun filterInvalidIp(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterInvalidIp = mapped
    }

    /**
     * @param value Identify elements: Set the total number of elements on the Browse page.
     */
    @JvmName("tbldrkaslphfwhrv")
    public suspend fun flowHijackJumpTimes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowHijackJumpTimes = mapped
    }

    /**
     * @param value Hijacking ID: Set the matching key information. Enter the hijacking keyword or key element, with an asterisk (*) allowed.
     */
    @JvmName("cbncoojefiurbglg")
    public suspend fun flowHijackLogo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowHijackLogo = mapped
    }

    /**
     * @param value Whether to ignore certificate errors during certificate verification in SSL Handshake and continue browsing. 0-do not ignore, 1-ignore. The default value is 1.
     */
    @JvmName("ntlnvuslffxeuuqt")
    public suspend fun ignoreCertificateError(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCertificateError = mapped
    }

    /**
     * @param value Monitoring timeout, in ms. Not required, 20000 by default.
     */
    @JvmName("cjodjpflcfdphari")
    public suspend fun monitorTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorTimeout = mapped
    }

    /**
     * @param value Monitoring the page appears to be tampered with elements other than the domain settings that belong to the page. Common manifestations are pop-up advertisements, floating advertisements, jumps, etc.  Fill in the format: Domain name: Element. You can fill multiple elements separated by a vertical bar (|). For example, www.aliyun.com:|/cc/bb/a.gif |/vv/bb/cc.jpg indicates that all the other elements of the www.aliyun.com domain name except the basic document,/cc/bb/a.gif, and/vv/bb/cc.jpg are tampered.
     */
    @JvmName("nrgramnabkrcthno")
    public suspend fun pageTamper(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pageTamper = mapped
    }

    /**
     * @param value When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
     */
    @JvmName("yoouufpygedjdlkr")
    public suspend fun redirection(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirection = mapped
    }

    /**
     * @param value The slow element threshold, in ms, is 5000 by default and can be selected from 1 to 300000ms.
     */
    @JvmName("csxlogvtqfkifxuv")
    public suspend fun slowElementThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slowElementThreshold = mapped
    }

    /**
     * @param value The target URL.
     */
    @JvmName("rumesvrtuvinjxqq")
    public suspend fun targetUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetUrl = mapped
    }

    /**
     * @param value The verification string is an arbitrary string in the source code of the monitoring page. If the source code returned by the client contains any of the blacklisted strings, 650 error is returned. Multiple strings are separated by a vertical bar (|).
     */
    @JvmName("atimggubfhftyxlu")
    public suspend fun verifyStringBlacklist(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyStringBlacklist = mapped
    }

    /**
     * @param value The verification string is an arbitrary string in the source code of the monitoring page. The source code returned by the client must contain all the strings in the whitelist. Otherwise, 650 error is returned. Multiple strings are separated by a vertical bar (|).
     */
    @JvmName("nscxmobmhyndbivr")
    public suspend fun verifyStringWhitelist(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyStringWhitelist = mapped
    }

    /**
     * @param value The maximum waiting time, in ms, is 5000 by default and can be selected from 5000 ms to 300000ms.
     */
    @JvmName("mmibdpoyufylwkxg")
    public suspend fun waitCompletionTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitCompletionTime = mapped
    }

    internal fun build(): SyntheticTaskMonitorConfWebsiteArgs = SyntheticTaskMonitorConfWebsiteArgs(
        automaticScrolling = automaticScrolling,
        customHeader = customHeader,
        customHeaderContent = customHeaderContent,
        disableCache = disableCache,
        disableCompression = disableCompression,
        dnsHijackWhitelist = dnsHijackWhitelist,
        elementBlacklist = elementBlacklist,
        filterInvalidIp = filterInvalidIp,
        flowHijackJumpTimes = flowHijackJumpTimes,
        flowHijackLogo = flowHijackLogo,
        ignoreCertificateError = ignoreCertificateError,
        monitorTimeout = monitorTimeout,
        pageTamper = pageTamper,
        redirection = redirection,
        slowElementThreshold = slowElementThreshold,
        targetUrl = targetUrl ?: throw PulumiNullFieldException("targetUrl"),
        verifyStringBlacklist = verifyStringBlacklist,
        verifyStringWhitelist = verifyStringWhitelist,
        waitCompletionTime = waitCompletionTime,
    )
}
