@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property notifyChannels The notification method. Valid values: dingTalk, sms, webhook, email, and wechat.
 * @property notifyObjects Sets the notification object. See `notify_objects` below.
 */
public data class DispatchRuleNotifyRule(
    public val notifyChannels: List<String>,
    public val notifyObjects: List<DispatchRuleNotifyRuleNotifyObject>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.DispatchRuleNotifyRule): DispatchRuleNotifyRule = DispatchRuleNotifyRule(
            notifyChannels = javaType.notifyChannels().map({ args0 -> args0 }),
            notifyObjects = javaType.notifyObjects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.DispatchRuleNotifyRuleNotifyObject.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
