@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alertContactGroupId The first ID of the resource.
 * @property alertContactGroupName The name of the resource.
 * @property contactIds contact ids.
 * @property createTime The creation time of the resource.
 * @property id The ID of the Alert Contact Group.
 */
public data class GetAlertContactGroupsGroup(
    public val alertContactGroupId: String,
    public val alertContactGroupName: String,
    public val contactIds: List<String>,
    public val createTime: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetAlertContactGroupsGroup): GetAlertContactGroupsGroup = GetAlertContactGroupsGroup(
            alertContactGroupId = javaType.alertContactGroupId(),
            alertContactGroupName = javaType.alertContactGroupName(),
            contactIds = javaType.contactIds().map({ args0 -> args0 }),
            createTime = javaType.createTime(),
            id = javaType.id(),
        )
    }
}
