@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAlertContactGroups.
 * @property alertContactGroupName
 * @property contactId
 * @property contactName
 * @property groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 */
public data class GetAlertContactGroupsResult(
    public val alertContactGroupName: String? = null,
    public val contactId: String? = null,
    public val contactName: String? = null,
    public val groups: List<GetAlertContactGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetAlertContactGroupsResult): GetAlertContactGroupsResult = GetAlertContactGroupsResult(
            alertContactGroupName = javaType.alertContactGroupName().map({ args0 -> args0 }).orElse(null),
            contactId = javaType.contactId().map({ args0 -> args0 }).orElse(null),
            contactName = javaType.contactName().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetAlertContactGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
