@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alertContactId Contact ID.
 * @property alertContactName The name of the alert contact.
 * @property createTime The Creation Time Timestamp.
 * @property dingRobotWebhookUrl The webhook URL of the DingTalk chatbot.
 * @property email The email address of the alert contact.
 * @property id The ID of the Alert Contact.
 * @property phoneNum The mobile number of the alert contact.
 * @property systemNoc Specifies whether the alert contact receives system notifications.
 * @property webhook Webhook Information.
 */
public data class GetAlertContactsContact(
    public val alertContactId: String,
    public val alertContactName: String,
    public val createTime: String,
    public val dingRobotWebhookUrl: String,
    public val email: String,
    public val id: String,
    public val phoneNum: String,
    public val systemNoc: Boolean,
    public val webhook: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetAlertContactsContact): GetAlertContactsContact = GetAlertContactsContact(
            alertContactId = javaType.alertContactId(),
            alertContactName = javaType.alertContactName(),
            createTime = javaType.createTime(),
            dingRobotWebhookUrl = javaType.dingRobotWebhookUrl(),
            email = javaType.email(),
            id = javaType.id(),
            phoneNum = javaType.phoneNum(),
            systemNoc = javaType.systemNoc(),
            webhook = javaType.webhook(),
        )
    }
}
