@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAlertContacts.
 * @property alertContactName
 * @property contacts
 * @property email
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property phoneNum
 */
public data class GetAlertContactsResult(
    public val alertContactName: String? = null,
    public val contacts: List<GetAlertContactsContact>,
    public val email: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val phoneNum: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetAlertContactsResult): GetAlertContactsResult = GetAlertContactsResult(
            alertContactName = javaType.alertContactName().map({ args0 -> args0 }).orElse(null),
            contacts = javaType.contacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetAlertContactsContact.Companion.toKotlin(args0)
                })
            }),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            phoneNum = javaType.phoneNum().map({ args0 -> args0 }).orElse(null),
        )
    }
}
