@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dispatchRuleId Dispatch rule ID.
 * @property dispatchRuleName The name of the dispatch rule.
 * @property dispatchType
 * @property groupRules Sets the event group.
 * @property id The ID of the Dispatch Rule.
 * @property labelMatchExpressionGrids Sets the dispatch rule.
 * @property notifyRules Sets the notification rule.
 * @property status The resource status of Alert Dispatch Rule.
 */
public data class GetDispatchRulesRule(
    public val dispatchRuleId: String,
    public val dispatchRuleName: String,
    public val dispatchType: String,
    public val groupRules: List<GetDispatchRulesRuleGroupRule>,
    public val id: String,
    public val labelMatchExpressionGrids: List<GetDispatchRulesRuleLabelMatchExpressionGrid>,
    public val notifyRules: List<GetDispatchRulesRuleNotifyRule>,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetDispatchRulesRule): GetDispatchRulesRule = GetDispatchRulesRule(
            dispatchRuleId = javaType.dispatchRuleId(),
            dispatchRuleName = javaType.dispatchRuleName(),
            dispatchType = javaType.dispatchType(),
            groupRules = javaType.groupRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetDispatchRulesRuleGroupRule.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            labelMatchExpressionGrids = javaType.labelMatchExpressionGrids().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetDispatchRulesRuleLabelMatchExpressionGrid.Companion.toKotlin(args0)
                })
            }),
            notifyRules = javaType.notifyRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetDispatchRulesRuleNotifyRule.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
        )
    }
}
