@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property groupId
 * @property groupInterval The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
 * @property groupWaitTime The duration for which the system waits after the first alert is sent. After the duration, all alerts are sent in a single notification to the handler.
 * @property groupingFields The fields that are used to group events. Events with the same field content are assigned to a group. Alerts with the same specified grouping field are sent to the handler in separate notifications.
 * @property repeatInterval The silence period of repeated alerts. All alerts are repeatedly sent at specified intervals until the alerts are cleared. The minimum value is 61. Default to 600.
 */
public data class GetDispatchRulesRuleGroupRule(
    public val groupId: Int,
    public val groupInterval: Int,
    public val groupWaitTime: Int,
    public val groupingFields: List<String>,
    public val repeatInterval: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetDispatchRulesRuleGroupRule): GetDispatchRulesRuleGroupRule = GetDispatchRulesRuleGroupRule(
            groupId = javaType.groupId(),
            groupInterval = javaType.groupInterval(),
            groupWaitTime = javaType.groupWaitTime(),
            groupingFields = javaType.groupingFields().map({ args0 -> args0 }),
            repeatInterval = javaType.repeatInterval(),
        )
    }
}
