@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterId The ID of the Prometheus instance.
 * @property exporterType Integration Exporter Type.
 * @property id The ID of the Integration Exporter. It formats as `<cluster_id>:<integration_type>:<instance_id>`.
 * @property instanceId The ID of the Integration Exporter instance.
 * @property instanceName The name of the instance.
 * @property integrationType The type of prometheus integration.
 * @property param Exporter configuration parameter json string.
 * @property target Monitor the target address.
 * @property version The version information.
 */
public data class GetIntegrationExportersIntegrationExporter(
    public val clusterId: String,
    public val exporterType: String,
    public val id: String,
    public val instanceId: Int,
    public val instanceName: String,
    public val integrationType: String,
    public val `param`: String,
    public val target: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetIntegrationExportersIntegrationExporter): GetIntegrationExportersIntegrationExporter = GetIntegrationExportersIntegrationExporter(
            clusterId = javaType.clusterId(),
            exporterType = javaType.exporterType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            integrationType = javaType.integrationType(),
            `param` = javaType.`param`(),
            target = javaType.target(),
            version = javaType.version(),
        )
    }
}
