@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIntegrationExporters.
 * @property clusterId The ID of the Prometheus instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property integrationExporters A list of Integration Exporters. Each element contains the following attributes:
 * @property integrationType The type of prometheus integration.
 * @property outputFile
 */
public data class GetIntegrationExportersResult(
    public val clusterId: String,
    public val id: String,
    public val ids: List<String>,
    public val integrationExporters: List<GetIntegrationExportersIntegrationExporter>,
    public val integrationType: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetIntegrationExportersResult): GetIntegrationExportersResult = GetIntegrationExportersResult(
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            integrationExporters = javaType.integrationExporters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetIntegrationExportersIntegrationExporter.Companion.toKotlin(args0)
                })
            }),
            integrationType = javaType.integrationType(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
