@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property annotations The annotations of the alert rule.
 * @property clusterId The ID of the cluster.
 * @property dispatchRuleId The ID of the notification policy. This parameter is required when the `notify_type` parameter is set to `DISPATCH_RULE`.
 * @property duration The duration of the alert.
 * @property expression The alert rule expression that follows the PromQL syntax..
 * @property id The ID of the Prometheus Alert Rule.
 * @property labels The labels of the resource.
 * @property message The message of the alert notification.
 * @property notifyType The method of sending the alert notification. Valid values: `ALERT_MANAGER`, `DISPATCH_RULE`.
 * @property prometheusAlertRuleId The first ID of the resource.
 * @property prometheusAlertRuleName The name of the resource.
 * @property status The status of the resource. Valid values: `0`, `1`.
 * @property type The type of the alert rule.
 */
public data class GetPrometheusAlertRulesRule(
    public val annotations: List<GetPrometheusAlertRulesRuleAnnotation>,
    public val clusterId: String,
    public val dispatchRuleId: String,
    public val duration: String,
    public val expression: String,
    public val id: String,
    public val labels: List<GetPrometheusAlertRulesRuleLabel>,
    public val message: String,
    public val notifyType: String,
    public val prometheusAlertRuleId: String,
    public val prometheusAlertRuleName: String,
    public val status: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetPrometheusAlertRulesRule): GetPrometheusAlertRulesRule = GetPrometheusAlertRulesRule(
            annotations = javaType.annotations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusAlertRulesRuleAnnotation.Companion.toKotlin(args0)
                })
            }),
            clusterId = javaType.clusterId(),
            dispatchRuleId = javaType.dispatchRuleId(),
            duration = javaType.duration(),
            expression = javaType.expression(),
            id = javaType.id(),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusAlertRulesRuleLabel.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            notifyType = javaType.notifyType(),
            prometheusAlertRuleId = javaType.prometheusAlertRuleId(),
            prometheusAlertRuleName = javaType.prometheusAlertRuleName(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
