@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterId The ID of the Prometheus instance.
 * @property configYaml The monitoring configuration. The value is a YAML string.
 * @property id The ID of the Prometheus Monitoring. It formats as `<cluster_id>:<monitoring_name>:<type>`.
 * @property monitoringName The name of the monitoring configuration.
 * @property status The status of the monitoring configuration. Valid values: `run`, `stop`.
 * @property type The type of the monitoring configuration. Valid values: `serviceMonitor`, `podMonitor`, `customJob`, `probe`.
 */
public data class GetPrometheusMonitoringsPrometheusMonitoring(
    public val clusterId: String,
    public val configYaml: String,
    public val id: String,
    public val monitoringName: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetPrometheusMonitoringsPrometheusMonitoring): GetPrometheusMonitoringsPrometheusMonitoring = GetPrometheusMonitoringsPrometheusMonitoring(
            clusterId = javaType.clusterId(),
            configYaml = javaType.configYaml(),
            id = javaType.id(),
            monitoringName = javaType.monitoringName(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
