@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPrometheusMonitorings.
 * @property clusterId The ID of the Prometheus instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Prometheus Monitoring names.
 * @property outputFile
 * @property prometheusMonitorings A list of Prometheus Monitorings. Each element contains the following attributes:
 * @property status The status of the monitoring configuration.
 * @property type The type of the monitoring configuration.
 */
public data class GetPrometheusMonitoringsResult(
    public val clusterId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val prometheusMonitorings: List<GetPrometheusMonitoringsPrometheusMonitoring>,
    public val status: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetPrometheusMonitoringsResult): GetPrometheusMonitoringsResult = GetPrometheusMonitoringsResult(
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            prometheusMonitorings = javaType.prometheusMonitorings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusMonitoringsPrometheusMonitoring.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
