@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authToken The token used to access the data source.
 * @property clusterId The ID of the cluster.
 * @property clusterName The name of the cluster.
 * @property clusterType The type of the cluster.
 * @property grafanaInstanceId The ID of the Grafana workspace.
 * @property httpApiInterUrl Http api public network address.
 * @property httpApiIntraUrl Http api intranet address.
 * @property id The ID of the Prometheus.
 * @property pushGateWayInterUrl PushGateway public network Url.
 * @property pushGateWayIntraUrl PushGateway intranet Url.
 * @property remoteReadInterUrl Public Url of remoteRead.
 * @property remoteReadIntraUrl RemoteRead intranet Url.
 * @property remoteWriteInterUrl RemoteWrite public Url.
 * @property remoteWriteIntraUrl RemoteWrite Intranet Url.
 * @property resourceGroupId The ID of the resource group.
 * @property securityGroupId The ID of the security group.
 * @property subClustersJson The child instance json string of the globalView instance.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The ID of the VSwitch.
 */
public data class GetPrometheusPromethei(
    public val authToken: String,
    public val clusterId: String,
    public val clusterName: String,
    public val clusterType: String,
    public val grafanaInstanceId: String,
    public val httpApiInterUrl: String,
    public val httpApiIntraUrl: String,
    public val id: String,
    public val pushGateWayInterUrl: String,
    public val pushGateWayIntraUrl: String,
    public val remoteReadInterUrl: String,
    public val remoteReadIntraUrl: String,
    public val remoteWriteInterUrl: String,
    public val remoteWriteIntraUrl: String,
    public val resourceGroupId: String,
    public val securityGroupId: String,
    public val subClustersJson: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetPrometheusPromethei): GetPrometheusPromethei = GetPrometheusPromethei(
            authToken = javaType.authToken(),
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            clusterType = javaType.clusterType(),
            grafanaInstanceId = javaType.grafanaInstanceId(),
            httpApiInterUrl = javaType.httpApiInterUrl(),
            httpApiIntraUrl = javaType.httpApiIntraUrl(),
            id = javaType.id(),
            pushGateWayInterUrl = javaType.pushGateWayInterUrl(),
            pushGateWayIntraUrl = javaType.pushGateWayIntraUrl(),
            remoteReadInterUrl = javaType.remoteReadInterUrl(),
            remoteReadIntraUrl = javaType.remoteReadIntraUrl(),
            remoteWriteInterUrl = javaType.remoteWriteInterUrl(),
            remoteWriteIntraUrl = javaType.remoteWriteIntraUrl(),
            resourceGroupId = javaType.resourceGroupId(),
            securityGroupId = javaType.securityGroupId(),
            subClustersJson = javaType.subClustersJson(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
