@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getPrometheus.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Prometheus names.
 * @property outputFile
 * @property prometheis A list of Prometheus. Each element contains the following attributes:
 * @property resourceGroupId The ID of the resource group.
 * @property tags The tag of the Prometheus.
 */
public data class GetPrometheusResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val prometheis: List<GetPrometheusPromethei>,
    public val resourceGroupId: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetPrometheusResult): GetPrometheusResult = GetPrometheusResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            prometheis = javaType.prometheis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetPrometheusPromethei.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
