@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterId The ID of the Prometheus instance.
 * @property id The ID of the Remote Write. It formats as `<cluster_id>:<remote_write_name>`.
 * @property remoteWriteName The name of the Remote Write configuration item.
 * @property remoteWriteYaml The details of the Remote Write configuration item. The value is in the YAML format.
 */
public data class GetRemoteWritesRemoteWrite(
    public val clusterId: String,
    public val id: String,
    public val remoteWriteName: String,
    public val remoteWriteYaml: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetRemoteWritesRemoteWrite): GetRemoteWritesRemoteWrite = GetRemoteWritesRemoteWrite(
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            remoteWriteName = javaType.remoteWriteName(),
            remoteWriteYaml = javaType.remoteWriteYaml(),
        )
    }
}
