@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRemoteWrites.
 * @property clusterId The ID of the Prometheus instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Remote Write names.
 * @property outputFile
 * @property remoteWrites A list of Remote Writes. Each element contains the following attributes:
 */
public data class GetRemoteWritesResult(
    public val clusterId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val remoteWrites: List<GetRemoteWritesRemoteWrite>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.GetRemoteWritesResult): GetRemoteWritesResult = GetRemoteWritesResult(
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            remoteWrites = javaType.remoteWrites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.GetRemoteWritesRemoteWrite.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
