@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expect Expected value.
 * @property operator Condition: gt: greater than; gte: greater than or equal to; lt: less than; te: less than or equal to; eq: equal to; neq: not equal to; ctn: contains; nctn: does not contain; exist: exists; n_exist: does not exist; belong: belongs to; reg_match: regular matching.
 * @property target Check the target. If the target is HttpResCode, HttpResBody, or httpressetime, you do not need to specify the target. If the target is HttpResHead, you need to specify the key in the header. If the target is HttpResHead, you need to use jsonPath.
 * @property type Assertion type, including: httpresead, httpresead, HttpResBody, HttpResBodyJson, httpressetime, IcmpPackLoss (packet loss rate), IcmpPackMaxLatency (maximum packet delay ms), icmppackwebscreen, fmppackavglatency (average delay rendering), TraceRouteHops (number of hops), dnsarecname, websiteOnload (full load time), see the supplement below for specific use.
 */
public data class SyntheticTaskAvailableAssertion(
    public val `expect`: String,
    public val `operator`: String,
    public val target: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskAvailableAssertion): SyntheticTaskAvailableAssertion = SyntheticTaskAvailableAssertion(
            `expect` = javaType.`expect`(),
            `operator` = javaType.`operator`(),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
