@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customHost Custom host. See `custom_host` below.
 * @property ipType IpType.
 * @property isOpenTrace Whether to enable link tracking.
 * @property monitorSamples Whether the monitoring samples are evenly distributed:
 * - 0: No
 * 1: Yes.
 * @property traceClientType Link trace client type:
 * - 0:ARMS Agent
 * - 1:OpenTelemetry
 * - 2:Jaeger.
 * @property xtraceRegion The link data is reported to the region.
 */
public data class SyntheticTaskCommonSetting(
    public val customHost: SyntheticTaskCommonSettingCustomHost? = null,
    public val ipType: Int? = null,
    public val isOpenTrace: Boolean? = null,
    public val monitorSamples: Int? = null,
    public val traceClientType: Int? = null,
    public val xtraceRegion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskCommonSetting): SyntheticTaskCommonSetting = SyntheticTaskCommonSetting(
            customHost = javaType.customHost().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskCommonSettingCustomHost.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipType = javaType.ipType().map({ args0 -> args0 }).orElse(null),
            isOpenTrace = javaType.isOpenTrace().map({ args0 -> args0 }).orElse(null),
            monitorSamples = javaType.monitorSamples().map({ args0 -> args0 }).orElse(null),
            traceClientType = javaType.traceClientType().map({ args0 -> args0 }).orElse(null),
            xtraceRegion = javaType.xtraceRegion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
