@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property apiHttp HTTP(S) task configuration information. See `api_http` below.
 * @property fileDownload File download type task configuration. See `file_download` below.
 * @property netDns The configuration parameters of the DNS dial test. Required when TaskType is 3. See `net_dns` below.
 * @property netIcmp ICMP dialing configuration parameters. Required when TaskType is 1. See `net_icmp` below.
 * @property netTcp The configuration parameters of TCP dial test. Required when TaskType is 2. See `net_tcp` below.
 * @property stream Streaming Media Dial Test Configuration. See `stream` below.
 * @property website Website speed measurement type task configuration. See `website` below.
 */
public data class SyntheticTaskMonitorConf(
    public val apiHttp: SyntheticTaskMonitorConfApiHttp? = null,
    public val fileDownload: SyntheticTaskMonitorConfFileDownload? = null,
    public val netDns: SyntheticTaskMonitorConfNetDns? = null,
    public val netIcmp: SyntheticTaskMonitorConfNetIcmp? = null,
    public val netTcp: SyntheticTaskMonitorConfNetTcp? = null,
    public val stream: SyntheticTaskMonitorConfStream? = null,
    public val website: SyntheticTaskMonitorConfWebsite? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskMonitorConf): SyntheticTaskMonitorConf = SyntheticTaskMonitorConf(
            apiHttp = javaType.apiHttp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfApiHttp.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileDownload = javaType.fileDownload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfFileDownload.Companion.toKotlin(args0)
                })
            }).orElse(null),
            netDns = javaType.netDns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfNetDns.Companion.toKotlin(args0)
                })
            }).orElse(null),
            netIcmp = javaType.netIcmp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfNetIcmp.Companion.toKotlin(args0)
                })
            }).orElse(null),
            netTcp = javaType.netTcp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfNetTcp.Companion.toKotlin(args0)
                })
            }).orElse(null),
            stream = javaType.stream().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfStream.Companion.toKotlin(args0)
                })
            }).orElse(null),
            website = javaType.website().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfWebsite.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
