@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property connectTimeout Connection timeout, in ms. Default 5000. Optional range: 1000-300000ms.
 * @property method HTTP method, GET or POST.
 * @property requestBody HTTP request body. See `request_body` below.
 * @property requestHeaders HTTP request header.
 * @property targetUrl The target URL.
 * @property timeout TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
 */
public data class SyntheticTaskMonitorConfApiHttp(
    public val connectTimeout: Int? = null,
    public val method: String? = null,
    public val requestBody: SyntheticTaskMonitorConfApiHttpRequestBody? = null,
    public val requestHeaders: Map<String, String>? = null,
    public val targetUrl: String,
    public val timeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskMonitorConfApiHttp): SyntheticTaskMonitorConfApiHttp = SyntheticTaskMonitorConfApiHttp(
            connectTimeout = javaType.connectTimeout().map({ args0 -> args0 }).orElse(null),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            requestBody = javaType.requestBody().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.arms.kotlin.outputs.SyntheticTaskMonitorConfApiHttpRequestBody.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requestHeaders = javaType.requestHeaders().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetUrl = javaType.targetUrl(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
