@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property connectionTimeout Connection timeout time, in ms. Default 5000. Optional range: 1000-120000ms.
 * @property customHeaderContent Custom header, in JSON Map format.
 * @property downloadKernel Download the kernel.
 * - 1:curl
 * - 0:WinInet
 * Default 1.
 * @property ignoreCertificateAuthError Ignore CA Certificate authorization error 0: Do not ignore, 1: ignore, default 1.
 * @property ignoreCertificateCanceledError Ignore certificate revocation error 0: Do not ignore, 1: ignore, default 1.
 * @property ignoreCertificateOutOfDateError Ignore certificate expiration error 0: not ignored, 1: Ignored, default 1.
 * @property ignoreCertificateStatusError The certificate status error is ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
 * @property ignoreCertificateUntrustworthyError The certificate cannot be trusted and ignored. 0: Do not ignore, 1: IGNORE. The default value is 1.
 * @property ignoreCertificateUsingError Ignore certificate usage error 0: Do not ignore, 1: ignore, default 1.
 * @property ignoreInvalidHostError Invalid host error ignored, 0: not ignored, 1: Ignored, default 1.
 * @property monitorTimeout Monitoring timeout, in ms. Not required, 20000 by default.
 * @property quickProtocol Quick agreement
 * - 1:http1
 * - 2:http2
 * - 3:http3
 * Default 1.
 * @property redirection When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
 * @property targetUrl The target URL.
 * @property transmissionSize The transmission size, in KB. The default value is 2048KB. The transmission size of the downloaded file must be between 1 and 20480KB.
 * @property validateKeywords Verify keywords.
 * @property verifyWay The verification method.
 * - 0: Do not validate
 * - 1: Validation string
 * - 2:MD5 validation.
 * @property whiteList DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
 */
public data class SyntheticTaskMonitorConfFileDownload(
    public val connectionTimeout: Int? = null,
    public val customHeaderContent: Map<String, String>? = null,
    public val downloadKernel: Int? = null,
    public val ignoreCertificateAuthError: Int? = null,
    public val ignoreCertificateCanceledError: Int? = null,
    public val ignoreCertificateOutOfDateError: Int? = null,
    public val ignoreCertificateStatusError: Int? = null,
    public val ignoreCertificateUntrustworthyError: Int? = null,
    public val ignoreCertificateUsingError: Int? = null,
    public val ignoreInvalidHostError: Int? = null,
    public val monitorTimeout: Int? = null,
    public val quickProtocol: Int? = null,
    public val redirection: Int? = null,
    public val targetUrl: String,
    public val transmissionSize: Int? = null,
    public val validateKeywords: String? = null,
    public val verifyWay: Int? = null,
    public val whiteList: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskMonitorConfFileDownload): SyntheticTaskMonitorConfFileDownload = SyntheticTaskMonitorConfFileDownload(
            connectionTimeout = javaType.connectionTimeout().map({ args0 -> args0 }).orElse(null),
            customHeaderContent = javaType.customHeaderContent().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            downloadKernel = javaType.downloadKernel().map({ args0 -> args0 }).orElse(null),
            ignoreCertificateAuthError = javaType.ignoreCertificateAuthError().map({ args0 ->
                args0
            }).orElse(null),
            ignoreCertificateCanceledError = javaType.ignoreCertificateCanceledError().map({ args0 ->
                args0
            }).orElse(null),
            ignoreCertificateOutOfDateError = javaType.ignoreCertificateOutOfDateError().map({ args0 ->
                args0
            }).orElse(null),
            ignoreCertificateStatusError = javaType.ignoreCertificateStatusError().map({ args0 ->
                args0
            }).orElse(null),
            ignoreCertificateUntrustworthyError = javaType.ignoreCertificateUntrustworthyError().map({ args0 ->
                args0
            }).orElse(null),
            ignoreCertificateUsingError = javaType.ignoreCertificateUsingError().map({ args0 ->
                args0
            }).orElse(null),
            ignoreInvalidHostError = javaType.ignoreInvalidHostError().map({ args0 -> args0 }).orElse(null),
            monitorTimeout = javaType.monitorTimeout().map({ args0 -> args0 }).orElse(null),
            quickProtocol = javaType.quickProtocol().map({ args0 -> args0 }).orElse(null),
            redirection = javaType.redirection().map({ args0 -> args0 }).orElse(null),
            targetUrl = javaType.targetUrl(),
            transmissionSize = javaType.transmissionSize().map({ args0 -> args0 }).orElse(null),
            validateKeywords = javaType.validateKeywords().map({ args0 -> args0 }).orElse(null),
            verifyWay = javaType.verifyWay().map({ args0 -> args0 }).orElse(null),
            whiteList = javaType.whiteList().map({ args0 -> args0 }).orElse(null),
        )
    }
}
