@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dnsServerIpType The IP address type of the DNS server.
 * - 0 (default):ipv4
 * - 1:ipv6
 * 2: Automatic.
 * @property nsServer The IP address of the NS server. The default value is 114.114.114.114.
 * @property queryMethod DNS query method.
 * - 0 (default): Recursive
 * - 1: Iteration.
 * @property targetUrl The target URL.
 * @property timeout TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
 */
public data class SyntheticTaskMonitorConfNetDns(
    public val dnsServerIpType: Int? = null,
    public val nsServer: String? = null,
    public val queryMethod: Int? = null,
    public val targetUrl: String,
    public val timeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskMonitorConfNetDns): SyntheticTaskMonitorConfNetDns = SyntheticTaskMonitorConfNetDns(
            dnsServerIpType = javaType.dnsServerIpType().map({ args0 -> args0 }).orElse(null),
            nsServer = javaType.nsServer().map({ args0 -> args0 }).orElse(null),
            queryMethod = javaType.queryMethod().map({ args0 -> args0 }).orElse(null),
            targetUrl = javaType.targetUrl(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
