@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property interval The interval between TCP connections. The unit is milliseconds (ms), the minimum value is 200, the maximum value is 10000, and the default value is 200.
 * @property packageNum Number of ICMP(Ping) packets sent. The minimum value is 1, the maximum value is 50, and the default is 4.
 * @property packageSize The size of the sent ICMP(Ping) packet. The unit is byte. The ICMP(PING) packet size is limited to 32, 64, 128, 256, 512, 1024, 1080, and 1450.
 * @property splitPackage Whether to split ICMP(Ping) packets. The default is true.
 * @property targetUrl The target URL.
 * @property timeout TCP dial test timeout. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 20000.
 * @property tracertEnable Whether to enable tracert. The default is true.
 * @property tracertNumMax The maximum number of hops for tracert. The minimum value is 1, the maximum value is 128, and the default value is 20.
 * @property tracertTimeout The time-out of tracert. The unit is milliseconds (ms), the minimum value is 1000, the maximum value is 300000, and the default value is 60000.
 */
public data class SyntheticTaskMonitorConfNetIcmp(
    public val interval: Int? = null,
    public val packageNum: Int? = null,
    public val packageSize: Int? = null,
    public val splitPackage: Boolean? = null,
    public val targetUrl: String,
    public val timeout: Int? = null,
    public val tracertEnable: Boolean? = null,
    public val tracertNumMax: Int? = null,
    public val tracertTimeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskMonitorConfNetIcmp): SyntheticTaskMonitorConfNetIcmp = SyntheticTaskMonitorConfNetIcmp(
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            packageNum = javaType.packageNum().map({ args0 -> args0 }).orElse(null),
            packageSize = javaType.packageSize().map({ args0 -> args0 }).orElse(null),
            splitPackage = javaType.splitPackage().map({ args0 -> args0 }).orElse(null),
            targetUrl = javaType.targetUrl(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            tracertEnable = javaType.tracertEnable().map({ args0 -> args0 }).orElse(null),
            tracertNumMax = javaType.tracertNumMax().map({ args0 -> args0 }).orElse(null),
            tracertTimeout = javaType.tracertTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
