@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property customHeaderContent Custom header, in JSON Map format.
 * @property playerType Player, do not pass the default 12.
 * - 12:VLC
 * - 2:FlashPlayer.
 * @property streamAddressType Resource address type:
 * - 1: Resource address.
 * - 0: page address, not 0 by default.
 * @property streamMonitorTimeout Monitoring duration, in seconds, up to 60s, not 60 by default.
 * @property streamType Audio and video flags: 0-video, 1-audio.
 * @property targetUrl The target URL.
 * @property whiteList DNS hijack whitelist. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
 */
public data class SyntheticTaskMonitorConfStream(
    public val customHeaderContent: Map<String, String>? = null,
    public val playerType: Int? = null,
    public val streamAddressType: Int? = null,
    public val streamMonitorTimeout: Int? = null,
    public val streamType: Int? = null,
    public val targetUrl: String? = null,
    public val whiteList: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskMonitorConfStream): SyntheticTaskMonitorConfStream = SyntheticTaskMonitorConfStream(
            customHeaderContent = javaType.customHeaderContent().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            playerType = javaType.playerType().map({ args0 -> args0 }).orElse(null),
            streamAddressType = javaType.streamAddressType().map({ args0 -> args0 }).orElse(null),
            streamMonitorTimeout = javaType.streamMonitorTimeout().map({ args0 -> args0 }).orElse(null),
            streamType = javaType.streamType().map({ args0 -> args0 }).orElse(null),
            targetUrl = javaType.targetUrl().map({ args0 -> args0 }).orElse(null),
            whiteList = javaType.whiteList().map({ args0 -> args0 }).orElse(null),
        )
    }
}
