@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.arms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property automaticScrolling Whether to support automatic scrolling screen, loading page.
 * - 0 (default): No
 * 1: Yes.
 * @property customHeader Custom header.
 * - 0 (default): Off
 * - 1: Modify the first package
 * - 2: Modify all packages.
 * @property customHeaderContent Custom header, in JSON Map format.
 * @property disableCache Whether to disable caching.
 * - 0: not disabled
 * - 1 (default): Disabled.
 * @property disableCompression The Accept-Encoding field is used to determine whether to Accept compressed files. 0-do not disable, 1-disable, the default is 0.
 * @property dnsHijackWhitelist When a domain name (such as www.aliyun.com) is resolved, if the resolved IP address or CNAME is not in the DNS hijacking white list, the user will fail to access or return a target IP address that is not Aliyun. If the IP or CNAME in the resolution result is in the DNS white list, it will be determined that DNS hijacking has not occurred.  Fill in the format: Domain name: matching rules. Match rules support IP, IP wildcard, subnet mask, and CNAME. Multiple match rules can be filled in. Multiple match rules are separated by vertical bars (|). For example, www.aliyun.com:203.0.3.55 | 203.3.44.67 indicates that all other IP addresses under the www.aliyun.com domain except 203.0.3.55 and 203.3.44.67 are hijacked.
 * @property elementBlacklist If an element configured in the element blacklist appears during page loading, the element is not requested to be loaded.
 * @property filterInvalidIp Whether to filter invalid IP parameters. 0: filter, 1: do not filter. The default value is 0.
 * @property flowHijackJumpTimes Identify elements: Set the total number of elements on the Browse page.
 * @property flowHijackLogo Hijacking ID: Set the matching key information. Enter the hijacking keyword or key element, with an asterisk (*) allowed.
 * @property ignoreCertificateError Whether to ignore certificate errors during certificate verification in SSL Handshake and continue browsing. 0-do not ignore, 1-ignore. The default value is 1.
 * @property monitorTimeout Monitoring timeout, in ms. Not required, 20000 by default.
 * @property pageTamper Monitoring the page appears to be tampered with elements other than the domain settings that belong to the page. Common manifestations are pop-up advertisements, floating advertisements, jumps, etc.  Fill in the format: Domain name: Element. You can fill multiple elements separated by a vertical bar (|). For example, www.aliyun.com:|/cc/bb/a.gif |/vv/bb/cc.jpg indicates that all the other elements of the www.aliyun.com domain name except the basic document,/cc/bb/a.gif, and/vv/bb/cc.jpg are tampered.
 * @property redirection When redirection occurs, whether to continue browsing, 0-No, 1-Yes, the default is 1.
 * @property slowElementThreshold The slow element threshold, in ms, is 5000 by default and can be selected from 1 to 300000ms.
 * @property targetUrl The target URL.
 * @property verifyStringBlacklist The verification string is an arbitrary string in the source code of the monitoring page. If the source code returned by the client contains any of the blacklisted strings, 650 error is returned. Multiple strings are separated by a vertical bar (|).
 * @property verifyStringWhitelist The verification string is an arbitrary string in the source code of the monitoring page. The source code returned by the client must contain all the strings in the whitelist. Otherwise, 650 error is returned. Multiple strings are separated by a vertical bar (|).
 * @property waitCompletionTime The maximum waiting time, in ms, is 5000 by default and can be selected from 5000 ms to 300000ms.
 */
public data class SyntheticTaskMonitorConfWebsite(
    public val automaticScrolling: Int? = null,
    public val customHeader: Int? = null,
    public val customHeaderContent: Map<String, String>? = null,
    public val disableCache: Int? = null,
    public val disableCompression: Int? = null,
    public val dnsHijackWhitelist: String? = null,
    public val elementBlacklist: String? = null,
    public val filterInvalidIp: Int? = null,
    public val flowHijackJumpTimes: Int? = null,
    public val flowHijackLogo: String? = null,
    public val ignoreCertificateError: Int? = null,
    public val monitorTimeout: Int? = null,
    public val pageTamper: String? = null,
    public val redirection: Int? = null,
    public val slowElementThreshold: Int? = null,
    public val targetUrl: String,
    public val verifyStringBlacklist: String? = null,
    public val verifyStringWhitelist: String? = null,
    public val waitCompletionTime: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.arms.outputs.SyntheticTaskMonitorConfWebsite): SyntheticTaskMonitorConfWebsite = SyntheticTaskMonitorConfWebsite(
            automaticScrolling = javaType.automaticScrolling().map({ args0 -> args0 }).orElse(null),
            customHeader = javaType.customHeader().map({ args0 -> args0 }).orElse(null),
            customHeaderContent = javaType.customHeaderContent().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            disableCache = javaType.disableCache().map({ args0 -> args0 }).orElse(null),
            disableCompression = javaType.disableCompression().map({ args0 -> args0 }).orElse(null),
            dnsHijackWhitelist = javaType.dnsHijackWhitelist().map({ args0 -> args0 }).orElse(null),
            elementBlacklist = javaType.elementBlacklist().map({ args0 -> args0 }).orElse(null),
            filterInvalidIp = javaType.filterInvalidIp().map({ args0 -> args0 }).orElse(null),
            flowHijackJumpTimes = javaType.flowHijackJumpTimes().map({ args0 -> args0 }).orElse(null),
            flowHijackLogo = javaType.flowHijackLogo().map({ args0 -> args0 }).orElse(null),
            ignoreCertificateError = javaType.ignoreCertificateError().map({ args0 -> args0 }).orElse(null),
            monitorTimeout = javaType.monitorTimeout().map({ args0 -> args0 }).orElse(null),
            pageTamper = javaType.pageTamper().map({ args0 -> args0 }).orElse(null),
            redirection = javaType.redirection().map({ args0 -> args0 }).orElse(null),
            slowElementThreshold = javaType.slowElementThreshold().map({ args0 -> args0 }).orElse(null),
            targetUrl = javaType.targetUrl(),
            verifyStringBlacklist = javaType.verifyStringBlacklist().map({ args0 -> args0 }).orElse(null),
            verifyStringWhitelist = javaType.verifyStringWhitelist().map({ args0 -> args0 }).orElse(null),
            waitCompletionTime = javaType.waitCompletionTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
