@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin

import com.pulumi.alicloud.bastionhost.BastionhostFunctions.getHostAccountsPlain
import com.pulumi.alicloud.bastionhost.BastionhostFunctions.getHostGroupsPlain
import com.pulumi.alicloud.bastionhost.BastionhostFunctions.getHostShareKeysPlain
import com.pulumi.alicloud.bastionhost.BastionhostFunctions.getHostsPlain
import com.pulumi.alicloud.bastionhost.BastionhostFunctions.getInstancesPlain
import com.pulumi.alicloud.bastionhost.BastionhostFunctions.getUserGroupsPlain
import com.pulumi.alicloud.bastionhost.BastionhostFunctions.getUsersPlain
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostAccountsPlainArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostAccountsPlainArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostGroupsPlainArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostGroupsPlainArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostShareKeysPlainArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostShareKeysPlainArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostsPlainArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetHostsPlainArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetUserGroupsPlainArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetUserGroupsPlainArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostAccountsResult
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostGroupsResult
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostShareKeysResult
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostsResult
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetUserGroupsResult
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetUsersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostAccountsResult.Companion.toKotlin as getHostAccountsResultToKotlin
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostGroupsResult.Companion.toKotlin as getHostGroupsResultToKotlin
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostShareKeysResult.Companion.toKotlin as getHostShareKeysResultToKotlin
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostsResult.Companion.toKotlin as getHostsResultToKotlin
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetUserGroupsResult.Companion.toKotlin as getUserGroupsResultToKotlin
import com.pulumi.alicloud.bastionhost.kotlin.outputs.GetUsersResult.Companion.toKotlin as getUsersResultToKotlin

public object BastionhostFunctions {
    /**
     * This data source provides the Bastionhost Host Accounts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.bastionhost.getHostAccounts({
     *     hostId: "15",
     *     instanceId: "example_value",
     *     ids: [
     *         "1",
     *         "2",
     *     ],
     * });
     * export const bastionhostHostAccountId1 = ids.then(ids => ids.accounts?.[0]?.id);
     * const nameRegex = alicloud.bastionhost.getHostAccounts({
     *     hostId: "15",
     *     instanceId: "example_value",
     *     nameRegex: "^my-HostAccount",
     * });
     * export const bastionhostHostAccountId2 = nameRegex.then(nameRegex => nameRegex.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.bastionhost.get_host_accounts(host_id="15",
     *     instance_id="example_value",
     *     ids=[
     *         "1",
     *         "2",
     *     ])
     * pulumi.export("bastionhostHostAccountId1", ids.accounts[0].id)
     * name_regex = alicloud.bastionhost.get_host_accounts(host_id="15",
     *     instance_id="example_value",
     *     name_regex="^my-HostAccount")
     * pulumi.export("bastionhostHostAccountId2", name_regex.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.BastionHost.GetHostAccounts.Invoke(new()
     *     {
     *         HostId = "15",
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "1",
     *             "2",
     *         },
     *     });
     *     var nameRegex = AliCloud.BastionHost.GetHostAccounts.Invoke(new()
     *     {
     *         HostId = "15",
     *         InstanceId = "example_value",
     *         NameRegex = "^my-HostAccount",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["bastionhostHostAccountId1"] = ids&#46;Apply(getHostAccountsResult => getHostAccountsResult&#46;Accounts[0]?.Id),
     *         ["bastionhostHostAccountId2"] = nameRegex&#46;Apply(getHostAccountsResult => getHostAccountsResult&#46;Accounts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := bastionhost.GetHostAccounts(ctx, &bastionhost.GetHostAccountsArgs{
     * 			HostId:     "15",
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"1",
     * 				"2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostAccountId1", ids.Accounts[0].Id)
     * 		nameRegex, err := bastionhost.GetHostAccounts(ctx, &bastionhost.GetHostAccountsArgs{
     * 			HostId:     "15",
     * 			InstanceId: "example_value",
     * 			NameRegex:  pulumi.StringRef("^my-HostAccount"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostAccountId2", nameRegex.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetHostAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = BastionhostFunctions.getHostAccounts(GetHostAccountsArgs.builder()
     *             .hostId("15")
     *             .instanceId("example_value")
     *             .ids(
     *                 "1",
     *                 "2")
     *             .build());
     *         ctx.export("bastionhostHostAccountId1", ids.applyValue(getHostAccountsResult -> getHostAccountsResult.accounts()[0].id()));
     *         final var nameRegex = BastionhostFunctions.getHostAccounts(GetHostAccountsArgs.builder()
     *             .hostId("15")
     *             .instanceId("example_value")
     *             .nameRegex("^my-HostAccount")
     *             .build());
     *         ctx.export("bastionhostHostAccountId2", nameRegex.applyValue(getHostAccountsResult -> getHostAccountsResult.accounts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHostAccounts
     *       Arguments:
     *         hostId: '15'
     *         instanceId: example_value
     *         ids:
     *           - '1'
     *           - '2'
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHostAccounts
     *       Arguments:
     *         hostId: '15'
     *         instanceId: example_value
     *         nameRegex: ^my-HostAccount
     * outputs:
     *   bastionhostHostAccountId1: ${ids.accounts[0].id}
     *   bastionhostHostAccountId2: ${nameRegex.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHostAccounts.
     * @return A collection of values returned by getHostAccounts.
     */
    public suspend fun getHostAccounts(argument: GetHostAccountsPlainArgs): GetHostAccountsResult =
        getHostAccountsResultToKotlin(getHostAccountsPlain(argument.toJava()).await())

    /**
     * @see [getHostAccounts].
     * @param hostAccountName Specify the new hosting account's name, support the longest 128 characters.
     * @param hostId Specifies the database where you want to create your hosting account's host ID.
     * @param ids A list of Host Account IDs.
     * @param instanceId Specifies the database where you want to create your hosting account's host bastion host ID of.
     * @param nameRegex A regex string to filter results by Host Account name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param protocolName Specify the new hosting account of the agreement name. Valid values: USING SSH and RDP.
     * @return A collection of values returned by getHostAccounts.
     */
    public suspend fun getHostAccounts(
        hostAccountName: String? = null,
        hostId: String,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        protocolName: String? = null,
    ): GetHostAccountsResult {
        val argument = GetHostAccountsPlainArgs(
            hostAccountName = hostAccountName,
            hostId = hostId,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            protocolName = protocolName,
        )
        return getHostAccountsResultToKotlin(getHostAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bastionhost&#46;kotlin&#46;inputs&#46;GetHostAccountsPlainArgs].
     * @return A collection of values returned by getHostAccounts.
     */
    public suspend fun getHostAccounts(argument: suspend GetHostAccountsPlainArgsBuilder.() -> Unit): GetHostAccountsResult {
        val builder = GetHostAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostAccountsResultToKotlin(getHostAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Bastionhost Host Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.bastionhost.getHostGroups({
     *     instanceId: "bastionhost-cn-tl3xxxxxxx",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const bastionhostHostGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.bastionhost.getHostGroups({
     *     instanceId: "bastionhost-cn-tl3xxxxxxx",
     *     nameRegex: "^my-HostGroup",
     * });
     * export const bastionhostHostGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.bastionhost.get_host_groups(instance_id="bastionhost-cn-tl3xxxxxxx",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("bastionhostHostGroupId1", ids.groups[0].id)
     * name_regex = alicloud.bastionhost.get_host_groups(instance_id="bastionhost-cn-tl3xxxxxxx",
     *     name_regex="^my-HostGroup")
     * pulumi.export("bastionhostHostGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.BastionHost.GetHostGroups.Invoke(new()
     *     {
     *         InstanceId = "bastionhost-cn-tl3xxxxxxx",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.BastionHost.GetHostGroups.Invoke(new()
     *     {
     *         InstanceId = "bastionhost-cn-tl3xxxxxxx",
     *         NameRegex = "^my-HostGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["bastionhostHostGroupId1"] = ids&#46;Apply(getHostGroupsResult => getHostGroupsResult&#46;Groups[0]?.Id),
     *         ["bastionhostHostGroupId2"] = nameRegex&#46;Apply(getHostGroupsResult => getHostGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := bastionhost.GetHostGroups(ctx, &bastionhost.GetHostGroupsArgs{
     * 			InstanceId: "bastionhost-cn-tl3xxxxxxx",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := bastionhost.GetHostGroups(ctx, &bastionhost.GetHostGroupsArgs{
     * 			InstanceId: "bastionhost-cn-tl3xxxxxxx",
     * 			NameRegex:  pulumi.StringRef("^my-HostGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetHostGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = BastionhostFunctions.getHostGroups(GetHostGroupsArgs.builder()
     *             .instanceId("bastionhost-cn-tl3xxxxxxx")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("bastionhostHostGroupId1", ids.applyValue(getHostGroupsResult -> getHostGroupsResult.groups()[0].id()));
     *         final var nameRegex = BastionhostFunctions.getHostGroups(GetHostGroupsArgs.builder()
     *             .instanceId("bastionhost-cn-tl3xxxxxxx")
     *             .nameRegex("^my-HostGroup")
     *             .build());
     *         ctx.export("bastionhostHostGroupId2", nameRegex.applyValue(getHostGroupsResult -> getHostGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHostGroups
     *       Arguments:
     *         instanceId: bastionhost-cn-tl3xxxxxxx
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHostGroups
     *       Arguments:
     *         instanceId: bastionhost-cn-tl3xxxxxxx
     *         nameRegex: ^my-HostGroup
     * outputs:
     *   bastionhostHostGroupId1: ${ids.groups[0].id}
     *   bastionhostHostGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHostGroups.
     * @return A collection of values returned by getHostGroups.
     */
    public suspend fun getHostGroups(argument: GetHostGroupsPlainArgs): GetHostGroupsResult =
        getHostGroupsResultToKotlin(getHostGroupsPlain(argument.toJava()).await())

    /**
     * @see [getHostGroups].
     * @param hostGroupName Specify the New Host Group Name, Supports up to 128 Characters.
     * @param ids A list of Host Group IDs.
     * @param instanceId Specify the New Host Group Where the Bastion Host ID of.
     * @param nameRegex A regex string to filter results by Host Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getHostGroups.
     */
    public suspend fun getHostGroups(
        hostGroupName: String? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetHostGroupsResult {
        val argument = GetHostGroupsPlainArgs(
            hostGroupName = hostGroupName,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getHostGroupsResultToKotlin(getHostGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bastionhost&#46;kotlin&#46;inputs&#46;GetHostGroupsPlainArgs].
     * @return A collection of values returned by getHostGroups.
     */
    public suspend fun getHostGroups(argument: suspend GetHostGroupsPlainArgsBuilder.() -> Unit): GetHostGroupsResult {
        val builder = GetHostGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostGroupsResultToKotlin(getHostGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Bastionhost Host Share Keys of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.165.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.bastionhost.getHostShareKeys({
     *     instanceId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const bastionhostHostShareKeyId1 = ids.then(ids => ids.keys?.[0]?.id);
     * const nameRegex = alicloud.bastionhost.getHostShareKeys({
     *     instanceId: "example_value",
     *     nameRegex: "^my-HostShareKey",
     * });
     * export const bastionhostHostShareKeyId2 = nameRegex.then(nameRegex => nameRegex.keys?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.bastionhost.get_host_share_keys(instance_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("bastionhostHostShareKeyId1", ids.keys[0].id)
     * name_regex = alicloud.bastionhost.get_host_share_keys(instance_id="example_value",
     *     name_regex="^my-HostShareKey")
     * pulumi.export("bastionhostHostShareKeyId2", name_regex.keys[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.BastionHost.GetHostShareKeys.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.BastionHost.GetHostShareKeys.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         NameRegex = "^my-HostShareKey",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["bastionhostHostShareKeyId1"] = ids&#46;Apply(getHostShareKeysResult => getHostShareKeysResult&#46;Keys[0]?.Id),
     *         ["bastionhostHostShareKeyId2"] = nameRegex&#46;Apply(getHostShareKeysResult => getHostShareKeysResult&#46;Keys[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := bastionhost.GetHostShareKeys(ctx, &bastionhost.GetHostShareKeysArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostShareKeyId1", ids.Keys[0].Id)
     * 		nameRegex, err := bastionhost.GetHostShareKeys(ctx, &bastionhost.GetHostShareKeysArgs{
     * 			InstanceId: "example_value",
     * 			NameRegex:  pulumi.StringRef("^my-HostShareKey"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostShareKeyId2", nameRegex.Keys[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetHostShareKeysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = BastionhostFunctions.getHostShareKeys(GetHostShareKeysArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("bastionhostHostShareKeyId1", ids.applyValue(getHostShareKeysResult -> getHostShareKeysResult.keys()[0].id()));
     *         final var nameRegex = BastionhostFunctions.getHostShareKeys(GetHostShareKeysArgs.builder()
     *             .instanceId("example_value")
     *             .nameRegex("^my-HostShareKey")
     *             .build());
     *         ctx.export("bastionhostHostShareKeyId2", nameRegex.applyValue(getHostShareKeysResult -> getHostShareKeysResult.keys()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHostShareKeys
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHostShareKeys
     *       Arguments:
     *         instanceId: example_value
     *         nameRegex: ^my-HostShareKey
     * outputs:
     *   bastionhostHostShareKeyId1: ${ids.keys[0].id}
     *   bastionhostHostShareKeyId2: ${nameRegex.keys[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHostShareKeys.
     * @return A collection of values returned by getHostShareKeys.
     */
    public suspend fun getHostShareKeys(argument: GetHostShareKeysPlainArgs): GetHostShareKeysResult =
        getHostShareKeysResultToKotlin(getHostShareKeysPlain(argument.toJava()).await())

    /**
     * @see [getHostShareKeys].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Host Share Key IDs.
     * @param instanceId The ID of the Bastion instance.
     * @param nameRegex A regex string to filter results by Host Share Key name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getHostShareKeys.
     */
    public suspend fun getHostShareKeys(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetHostShareKeysResult {
        val argument = GetHostShareKeysPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getHostShareKeysResultToKotlin(getHostShareKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostShareKeys].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bastionhost&#46;kotlin&#46;inputs&#46;GetHostShareKeysPlainArgs].
     * @return A collection of values returned by getHostShareKeys.
     */
    public suspend fun getHostShareKeys(argument: suspend GetHostShareKeysPlainArgsBuilder.() -> Unit): GetHostShareKeysResult {
        val builder = GetHostShareKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostShareKeysResultToKotlin(getHostShareKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Bastionhost Hosts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.bastionhost.getHosts({
     *     instanceId: "example_value",
     *     ids: [
     *         "1",
     *         "2",
     *     ],
     * });
     * export const bastionhostHostId1 = ids.then(ids => ids.hosts?.[0]?.id);
     * const nameRegex = alicloud.bastionhost.getHosts({
     *     instanceId: "example_value",
     *     nameRegex: "^my-Host",
     * });
     * export const bastionhostHostId2 = nameRegex.then(nameRegex => nameRegex.hosts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.bastionhost.get_hosts(instance_id="example_value",
     *     ids=[
     *         "1",
     *         "2",
     *     ])
     * pulumi.export("bastionhostHostId1", ids.hosts[0].id)
     * name_regex = alicloud.bastionhost.get_hosts(instance_id="example_value",
     *     name_regex="^my-Host")
     * pulumi.export("bastionhostHostId2", name_regex.hosts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.BastionHost.GetHosts.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "1",
     *             "2",
     *         },
     *     });
     *     var nameRegex = AliCloud.BastionHost.GetHosts.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         NameRegex = "^my-Host",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["bastionhostHostId1"] = ids&#46;Apply(getHostsResult => getHostsResult&#46;Hosts[0]?.Id),
     *         ["bastionhostHostId2"] = nameRegex&#46;Apply(getHostsResult => getHostsResult&#46;Hosts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := bastionhost.GetHosts(ctx, &bastionhost.GetHostsArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"1",
     * 				"2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostId1", ids.Hosts[0].Id)
     * 		nameRegex, err := bastionhost.GetHosts(ctx, &bastionhost.GetHostsArgs{
     * 			InstanceId: "example_value",
     * 			NameRegex:  pulumi.StringRef("^my-Host"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostHostId2", nameRegex.Hosts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetHostsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = BastionhostFunctions.getHosts(GetHostsArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "1",
     *                 "2")
     *             .build());
     *         ctx.export("bastionhostHostId1", ids.applyValue(getHostsResult -> getHostsResult.hosts()[0].id()));
     *         final var nameRegex = BastionhostFunctions.getHosts(GetHostsArgs.builder()
     *             .instanceId("example_value")
     *             .nameRegex("^my-Host")
     *             .build());
     *         ctx.export("bastionhostHostId2", nameRegex.applyValue(getHostsResult -> getHostsResult.hosts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHosts
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - '1'
     *           - '2'
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getHosts
     *       Arguments:
     *         instanceId: example_value
     *         nameRegex: ^my-Host
     * outputs:
     *   bastionhostHostId1: ${ids.hosts[0].id}
     *   bastionhostHostId2: ${nameRegex.hosts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHosts.
     * @return A collection of values returned by getHosts.
     */
    public suspend fun getHosts(argument: GetHostsPlainArgs): GetHostsResult =
        getHostsResultToKotlin(getHostsPlain(argument.toJava()).await())

    /**
     * @see [getHosts].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param hostAddress The host address.
     * @param hostName Specify the new create a host name of the supports up to 128 characters.
     * @param ids A list of Host IDs.
     * @param instanceId Specify the new create a host where the Bastion host ID of.
     * @param nameRegex A regex string to filter results by Host name.
     * @param osType Specify the new create the host's operating system. Valid values: Linux Windows.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param source Specify the new create a host of source. Valid values: Local: localhost Ecs:ECS instance Rds:RDS exclusive cluster host.
     * @param sourceInstanceId Specify the newly created ECS instance ID or dedicated cluster host ID.
     * @param sourceInstanceState The source instance state.
     * @return A collection of values returned by getHosts.
     */
    public suspend fun getHosts(
        enableDetails: Boolean? = null,
        hostAddress: String? = null,
        hostName: String? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        osType: String? = null,
        outputFile: String? = null,
        source: String? = null,
        sourceInstanceId: String? = null,
        sourceInstanceState: String? = null,
    ): GetHostsResult {
        val argument = GetHostsPlainArgs(
            enableDetails = enableDetails,
            hostAddress = hostAddress,
            hostName = hostName,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            osType = osType,
            outputFile = outputFile,
            source = source,
            sourceInstanceId = sourceInstanceId,
            sourceInstanceState = sourceInstanceState,
        )
        return getHostsResultToKotlin(getHostsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHosts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bastionhost&#46;kotlin&#46;inputs&#46;GetHostsPlainArgs].
     * @return A collection of values returned by getHosts.
     */
    public suspend fun getHosts(argument: suspend GetHostsPlainArgsBuilder.() -> Unit): GetHostsResult {
        val builder = GetHostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostsResultToKotlin(getHostsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **NOTE:** From the version 1.132.0, the data source has been renamed to `alicloud.bastionhost.getInstances`.
     * This data source provides a list of cloud Bastionhost instances in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.63.0+ .
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * export = async () => {
     *     const instance = await alicloud.bastionhost.getInstances({
     *         descriptionRegex: "^bastionhost",
     *     });
     *     return {
     *         instance: instanceAlicloudBastionhostInstances.map(__item => __item.id),
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instance = alicloud.bastionhost.get_instances(description_regex="^bastionhost")
     * pulumi.export("instance", [__item["id"] for __item in instance_alicloud_bastionhost_instances])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instance = AliCloud.BastionHost.GetInstances.Invoke(new()
     *     {
     *         DescriptionRegex = "^bastionhost",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["instance"] = instanceAlicloudBastionhostInstances.Select(__item => __item.Id).ToList(),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := bastionhost.GetInstances(ctx, &bastionhost.GetInstancesArgs{
     * DescriptionRegex: pulumi.StringRef("^bastionhost"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("instance", pulumi.Array(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:5,14-56)))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instance = BastionhostFunctions.getInstances(GetInstancesArgs.builder()
     *             .descriptionRegex("^bastionhost")
     *             .build());
     *         ctx.export("instance", instanceAlicloudBastionhostInstances.stream().map(element -> element.id()).collect(toList()));
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param descriptionRegex A regex string to filter results by the instance description.
     * @param ids Matched instance IDs to filter data source result.
     * @param outputFile File name to persist data source output.
     * @param tags A map of tags assigned to the bastionhost instance. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instance = alicloud.bastionhost.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instance = alicloud.bastionhost.get_instances(tags={
     *     "tagKey1": "tagValue1",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instance = AliCloud.BastionHost.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bastionhost.GetInstances(ctx, &bastionhost.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instance = BastionhostFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.of("tagKey1", "tagValue1"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instance:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            descriptionRegex = descriptionRegex,
            ids = ids,
            outputFile = outputFile,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bastionhost&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Bastionhost User Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.bastionhost.getUserGroups({
     *     instanceId: "bastionhost-cn-xxxx",
     *     ids: [
     *         "1",
     *         "2",
     *     ],
     * });
     * export const bastionhostUserGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.bastionhost.getUserGroups({
     *     instanceId: "bastionhost-cn-xxxx",
     *     nameRegex: "^my-UserGroup",
     * });
     * export const bastionhostUserGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.bastionhost.get_user_groups(instance_id="bastionhost-cn-xxxx",
     *     ids=[
     *         "1",
     *         "2",
     *     ])
     * pulumi.export("bastionhostUserGroupId1", ids.groups[0].id)
     * name_regex = alicloud.bastionhost.get_user_groups(instance_id="bastionhost-cn-xxxx",
     *     name_regex="^my-UserGroup")
     * pulumi.export("bastionhostUserGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.BastionHost.GetUserGroups.Invoke(new()
     *     {
     *         InstanceId = "bastionhost-cn-xxxx",
     *         Ids = new[]
     *         {
     *             "1",
     *             "2",
     *         },
     *     });
     *     var nameRegex = AliCloud.BastionHost.GetUserGroups.Invoke(new()
     *     {
     *         InstanceId = "bastionhost-cn-xxxx",
     *         NameRegex = "^my-UserGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["bastionhostUserGroupId1"] = ids&#46;Apply(getUserGroupsResult => getUserGroupsResult&#46;Groups[0]?.Id),
     *         ["bastionhostUserGroupId2"] = nameRegex&#46;Apply(getUserGroupsResult => getUserGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := bastionhost.GetUserGroups(ctx, &bastionhost.GetUserGroupsArgs{
     * 			InstanceId: "bastionhost-cn-xxxx",
     * 			Ids: []string{
     * 				"1",
     * 				"2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostUserGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := bastionhost.GetUserGroups(ctx, &bastionhost.GetUserGroupsArgs{
     * 			InstanceId: "bastionhost-cn-xxxx",
     * 			NameRegex:  pulumi.StringRef("^my-UserGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostUserGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetUserGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = BastionhostFunctions.getUserGroups(GetUserGroupsArgs.builder()
     *             .instanceId("bastionhost-cn-xxxx")
     *             .ids(
     *                 "1",
     *                 "2")
     *             .build());
     *         ctx.export("bastionhostUserGroupId1", ids.applyValue(getUserGroupsResult -> getUserGroupsResult.groups()[0].id()));
     *         final var nameRegex = BastionhostFunctions.getUserGroups(GetUserGroupsArgs.builder()
     *             .instanceId("bastionhost-cn-xxxx")
     *             .nameRegex("^my-UserGroup")
     *             .build());
     *         ctx.export("bastionhostUserGroupId2", nameRegex.applyValue(getUserGroupsResult -> getUserGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getUserGroups
     *       Arguments:
     *         instanceId: bastionhost-cn-xxxx
     *         ids:
     *           - '1'
     *           - '2'
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getUserGroups
     *       Arguments:
     *         instanceId: bastionhost-cn-xxxx
     *         nameRegex: ^my-UserGroup
     * outputs:
     *   bastionhostUserGroupId1: ${ids.groups[0].id}
     *   bastionhostUserGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserGroups.
     * @return A collection of values returned by getUserGroups.
     */
    public suspend fun getUserGroups(argument: GetUserGroupsPlainArgs): GetUserGroupsResult =
        getUserGroupsResultToKotlin(getUserGroupsPlain(argument.toJava()).await())

    /**
     * @see [getUserGroups].
     * @param ids A list of User Group self IDs.
     * @param instanceId Specify the New Group of the Bastion Host of Instance Id.
     * @param nameRegex A regex string to filter results by User Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param userGroupName Specify the New Group Name. Supports up to 128 Characters.
     * @return A collection of values returned by getUserGroups.
     */
    public suspend fun getUserGroups(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        userGroupName: String? = null,
    ): GetUserGroupsResult {
        val argument = GetUserGroupsPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            userGroupName = userGroupName,
        )
        return getUserGroupsResultToKotlin(getUserGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bastionhost&#46;kotlin&#46;inputs&#46;GetUserGroupsPlainArgs].
     * @return A collection of values returned by getUserGroups.
     */
    public suspend fun getUserGroups(argument: suspend GetUserGroupsPlainArgsBuilder.() -> Unit): GetUserGroupsResult {
        val builder = GetUserGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserGroupsResultToKotlin(getUserGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Bastionhost Users of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.bastionhost.getUsers({
     *     instanceId: "example_value",
     *     ids: [
     *         "1",
     *         "10",
     *     ],
     * });
     * export const bastionhostUserId1 = ids.then(ids => ids.users?.[0]?.id);
     * const nameRegex = alicloud.bastionhost.getUsers({
     *     instanceId: "example_value",
     *     nameRegex: "^my-User",
     * });
     * export const bastionhostUserId2 = nameRegex.then(nameRegex => nameRegex.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.bastionhost.get_users(instance_id="example_value",
     *     ids=[
     *         "1",
     *         "10",
     *     ])
     * pulumi.export("bastionhostUserId1", ids.users[0].id)
     * name_regex = alicloud.bastionhost.get_users(instance_id="example_value",
     *     name_regex="^my-User")
     * pulumi.export("bastionhostUserId2", name_regex.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.BastionHost.GetUsers.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "1",
     *             "10",
     *         },
     *     });
     *     var nameRegex = AliCloud.BastionHost.GetUsers.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         NameRegex = "^my-User",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["bastionhostUserId1"] = ids&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *         ["bastionhostUserId2"] = nameRegex&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := bastionhost.GetUsers(ctx, &bastionhost.GetUsersArgs{
     * 			InstanceId: "example_value",
     * 			Ids: []string{
     * 				"1",
     * 				"10",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostUserId1", ids.Users[0].Id)
     * 		nameRegex, err := bastionhost.GetUsers(ctx, &bastionhost.GetUsersArgs{
     * 			InstanceId: "example_value",
     * 			NameRegex:  pulumi.StringRef("^my-User"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bastionhostUserId2", nameRegex.Users[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = BastionhostFunctions.getUsers(GetUsersArgs.builder()
     *             .instanceId("example_value")
     *             .ids(
     *                 "1",
     *                 "10")
     *             .build());
     *         ctx.export("bastionhostUserId1", ids.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *         final var nameRegex = BastionhostFunctions.getUsers(GetUsersArgs.builder()
     *             .instanceId("example_value")
     *             .nameRegex("^my-User")
     *             .build());
     *         ctx.export("bastionhostUserId2", nameRegex.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getUsers
     *       Arguments:
     *         instanceId: example_value
     *         ids:
     *           - '1'
     *           - '10'
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getUsers
     *       Arguments:
     *         instanceId: example_value
     *         nameRegex: ^my-User
     * outputs:
     *   bastionhostUserId1: ${ids.users[0].id}
     *   bastionhostUserId2: ${nameRegex.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param displayName Specify the New Created the User's Display Name. Supports up to 128 Characters.
     * @param ids A list of User IDs.
     * @param instanceId You Want to Query the User the Bastion Host ID of.
     * @param mobile Specify the New of the User That Created a Different Mobile Phone Number from Your.
     * @param nameRegex A regex string to filter results by User name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param source Specify the New of the User That Created the Source. Valid Values: Local: Local User RAM: Ram User. Valid values: `Local`, `Ram`.
     * @param sourceUserId Specify the Newly Created User Is Uniquely Identified. Indicates That the Parameter Is a Bastion Host Corresponding to the User with the Ram User's Unique Identifier. The Newly Created User Source Grant Permission to a RAM User (That Is, Source Used as a Ram), this Parameter Is Required. You Can Call Access Control of Listusers Interface from the Return Data Userid to Obtain the Parameters.
     * @param status The status of the resource. Valid values: `Frozen`, `Normal`.
     * @param userName Specify the New User Name. This Parameter Is Only by Letters, Lowercase Letters, Numbers, and Underscores (_), Supports up to 128 Characters.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(
        displayName: String? = null,
        ids: List<String>? = null,
        instanceId: String,
        mobile: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        source: String? = null,
        sourceUserId: String? = null,
        status: String? = null,
        userName: String? = null,
    ): GetUsersResult {
        val argument = GetUsersPlainArgs(
            displayName = displayName,
            ids = ids,
            instanceId = instanceId,
            mobile = mobile,
            nameRegex = nameRegex,
            outputFile = outputFile,
            source = source,
            sourceUserId = sourceUserId,
            status = status,
            userName = userName,
        )
        return getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bastionhost&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit): GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUsersResultToKotlin(getUsersPlain(builtArgument.toJava()).await())
    }
}
