@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HostAttachment].
 */
@PulumiTagMarker
public class HostAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostAttachmentArgs = HostAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostAttachmentArgsBuilder.() -> Unit) {
        val builder = HostAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HostAttachment {
        val builtJavaResource = com.pulumi.alicloud.bastionhost.HostAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HostAttachment(builtJavaResource)
    }
}

/**
 * Provides a Bastion Host Host Attachment resource to add host into one host group.
 * > **NOTE:** Available since v1.135.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[0]?.id,
 * }));
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0])});
 * const defaultInstance = new alicloud.bastionhost.Instance("default", {
 *     description: name,
 *     licenseCode: "bhah_ent_50_asset",
 *     planCode: "cloudbastion",
 *     storage: "5",
 *     bandwidth: "5",
 *     period: 1,
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     securityGroupIds: [defaultSecurityGroup&#46;id],
 * });
 * const defaultHostGroup = new alicloud.bastionhost.HostGroup("default", {
 *     hostGroupName: name,
 *     instanceId: defaultInstance.id,
 * });
 * const defaultHost = new alicloud.bastionhost.Host("default", {
 *     instanceId: defaultInstance.id,
 *     hostName: name,
 *     activeAddressType: "Private",
 *     hostPrivateAddress: "172.16.0.10",
 *     osType: "Linux",
 *     source: "Local",
 * });
 * const defaultHostAttachment = new alicloud.bastionhost.HostAttachment("default", {
 *     hostGroupId: defaultHostGroup.hostGroupId,
 *     hostId: defaultHost.hostId,
 *     instanceId: defaultInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
 *     cidr_block="10.4.0.0/16")
 * default_get_switches = alicloud.vpc.get_switches(cidr_block="10.4.0.0/24",
 *     vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_get_networks.ids[0])
 * default_instance = alicloud.bastionhost.Instance("default",
 *     description=name,
 *     license_code="bhah_ent_50_asset",
 *     plan_code="cloudbastion",
 *     storage="5",
 *     bandwidth="5",
 *     period=1,
 *     vswitch_id=default_get_switches.ids[0],
 *     security_group_ids=[default_security_group&#46;id])
 * default_host_group = alicloud.bastionhost.HostGroup("default",
 *     host_group_name=name,
 *     instance_id=default_instance.id)
 * default_host = alicloud.bastionhost.Host("default",
 *     instance_id=default_instance.id,
 *     host_name=name,
 *     active_address_type="Private",
 *     host_private_address="172.16.0.10",
 *     os_type="Linux",
 *     source="Local")
 * default_host_attachment = alicloud.bastionhost.HostAttachment("default",
 *     host_group_id=default_host_group.host_group_id,
 *     host_id=default_host.host_id,
 *     instance_id=default_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *     });
 *     var defaultInstance = new AliCloud.BastionHost.Instance("default", new()
 *     {
 *         Description = name,
 *         LicenseCode = "bhah_ent_50_asset",
 *         PlanCode = "cloudbastion",
 *         Storage = "5",
 *         Bandwidth = "5",
 *         Period = 1,
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         SecurityGroupIds = new[]
 *         {
 *             defaultSecurityGroup.Id,
 *         },
 *     });
 *     var defaultHostGroup = new AliCloud.BastionHost.HostGroup("default", new()
 *     {
 *         HostGroupName = name,
 *         InstanceId = defaultInstance.Id,
 *     });
 *     var defaultHost = new AliCloud.BastionHost.Host("default", new()
 *     {
 *         InstanceId = defaultInstance.Id,
 *         HostName = name,
 *         ActiveAddressType = "Private",
 *         HostPrivateAddress = "172.16.0.10",
 *         OsType = "Linux",
 *         Source = "Local",
 *     });
 *     var defaultHostAttachment = new AliCloud.BastionHost.HostAttachment("default", new()
 *     {
 *         HostGroupId = defaultHostGroup.HostGroupId,
 *         HostId = defaultHost.HostId,
 *         InstanceId = defaultInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 			CidrBlock: pulumi.StringRef("10.4.0.0/16"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			CidrBlock: pulumi.StringRef("10.4.0.0/24"),
 * 			VpcId:     pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId:    pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: pulumi.String(defaultGetNetworks.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := bastionhost.NewInstance(ctx, "default", &bastionhost.InstanceArgs{
 * 			Description: pulumi.String(name),
 * 			LicenseCode: pulumi.String("bhah_ent_50_asset"),
 * 			PlanCode:    pulumi.String("cloudbastion"),
 * 			Storage:     pulumi.String("5"),
 * 			Bandwidth:   pulumi.String("5"),
 * 			Period:      pulumi.Int(1),
 * 			VswitchId:   pulumi.String(defaultGetSwitches.Ids[0]),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				defaultSecurityGroup.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultHostGroup, err := bastionhost.NewHostGroup(ctx, "default", &bastionhost.HostGroupArgs{
 * 			HostGroupName: pulumi.String(name),
 * 			InstanceId:    defaultInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultHost, err := bastionhost.NewHost(ctx, "default", &bastionhost.HostArgs{
 * 			InstanceId:         defaultInstance.ID(),
 * 			HostName:           pulumi.String(name),
 * 			ActiveAddressType:  pulumi.String("Private"),
 * 			HostPrivateAddress: pulumi.String("172.16.0.10"),
 * 			OsType:             pulumi.String("Linux"),
 * 			Source:             pulumi.String("Local"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = bastionhost.NewHostAttachment(ctx, "default", &bastionhost.HostAttachmentArgs{
 * 			HostGroupId: defaultHostGroup.HostGroupId,
 * 			HostId:      defaultHost.HostId,
 * 			InstanceId:  defaultInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.bastionhost.Instance;
 * import com.pulumi.alicloud.bastionhost.InstanceArgs;
 * import com.pulumi.alicloud.bastionhost.HostGroup;
 * import com.pulumi.alicloud.bastionhost.HostGroupArgs;
 * import com.pulumi.alicloud.bastionhost.Host;
 * import com.pulumi.alicloud.bastionhost.HostArgs;
 * import com.pulumi.alicloud.bastionhost.HostAttachment;
 * import com.pulumi.alicloud.bastionhost.HostAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .description(name)
 *             .licenseCode("bhah_ent_50_asset")
 *             .planCode("cloudbastion")
 *             .storage("5")
 *             .bandwidth("5")
 *             .period("1")
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .securityGroupIds(defaultSecurityGroup.id())
 *             .build());
 *         var defaultHostGroup = new HostGroup("defaultHostGroup", HostGroupArgs.builder()
 *             .hostGroupName(name)
 *             .instanceId(defaultInstance.id())
 *             .build());
 *         var defaultHost = new Host("defaultHost", HostArgs.builder()
 *             .instanceId(defaultInstance.id())
 *             .hostName(name)
 *             .activeAddressType("Private")
 *             .hostPrivateAddress("172.16.0.10")
 *             .osType("Linux")
 *             .source("Local")
 *             .build());
 *         var defaultHostAttachment = new HostAttachment("defaultHostAttachment", HostAttachmentArgs.builder()
 *             .hostGroupId(defaultHostGroup.hostGroupId())
 *             .hostId(defaultHost.hostId())
 *             .instanceId(defaultInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *   defaultInstance:
 *     type: alicloud:bastionhost:Instance
 *     name: default
 *     properties:
 *       description: ${name}
 *       licenseCode: bhah_ent_50_asset
 *       planCode: cloudbastion
 *       storage: '5'
 *       bandwidth: '5'
 *       period: '1'
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       securityGroupIds:
 *         - ${defaultSecurityGroup.id}
 *   defaultHostGroup:
 *     type: alicloud:bastionhost:HostGroup
 *     name: default
 *     properties:
 *       hostGroupName: ${name}
 *       instanceId: ${defaultInstance.id}
 *   defaultHost:
 *     type: alicloud:bastionhost:Host
 *     name: default
 *     properties:
 *       instanceId: ${defaultInstance.id}
 *       hostName: ${name}
 *       activeAddressType: Private
 *       hostPrivateAddress: 172.16.0.10
 *       osType: Linux
 *       source: Local
 *   defaultHostAttachment:
 *     type: alicloud:bastionhost:HostAttachment
 *     name: default
 *     properties:
 *       hostGroupId: ${defaultHostGroup.hostGroupId}
 *       hostId: ${defaultHost.hostId}
 *       instanceId: ${defaultInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *         cidrBlock: 10.4.0.0/16
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         cidrBlock: 10.4.0.0/24
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Bastion Host Host Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:bastionhost/hostAttachment:HostAttachment example <instance_id>:<host_group_id>:<host_id>
 * ```
 */
public class HostAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.bastionhost.HostAttachment,
) : KotlinCustomResource(javaResource, HostAttachmentMapper) {
    /**
     * Specifies the added to the host group ID.
     */
    public val hostGroupId: Output<String>
        get() = javaResource.hostGroupId().applyValue({ args0 -> args0 })

    /**
     * Specified to be part of a host group of host ID.
     */
    public val hostId: Output<String>
        get() = javaResource.hostId().applyValue({ args0 -> args0 })

    /**
     * The bastion host instance id.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })
}

public object HostAttachmentMapper : ResourceMapper<HostAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.bastionhost.HostAttachment::class == javaResource::class

    override fun map(javaResource: Resource): HostAttachment = HostAttachment(
        javaResource as
            com.pulumi.alicloud.bastionhost.HostAttachment,
    )
}

/**
 * @see [HostAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostAttachment].
 */
public suspend fun hostAttachment(
    name: String,
    block: suspend HostAttachmentResourceBuilder.() -> Unit,
): HostAttachment {
    val builder = HostAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostAttachment(name: String): HostAttachment {
    val builder = HostAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
