@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin

import com.pulumi.alicloud.bastionhost.kotlin.outputs.InstanceAdAuthServer
import com.pulumi.alicloud.bastionhost.kotlin.outputs.InstanceLdapAuthServer
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.bastionhost.kotlin.outputs.InstanceAdAuthServer.Companion.toKotlin as instanceAdAuthServerToKotlin
import com.pulumi.alicloud.bastionhost.kotlin.outputs.InstanceLdapAuthServer.Companion.toKotlin as instanceLdapAuthServerToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.bastionhost.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Yundun_bastionhost instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:bastionhost/instance:Instance example bastionhost-exampe123456
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.bastionhost.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The AD auth server of the Instance. See `ad_auth_server` below.
     */
    public val adAuthServers: Output<List<InstanceAdAuthServer>>
        get() = javaResource.adAuthServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceAdAuthServerToKotlin(args0) })
            })
        })

    /**
     * The bandwidth of Cloud Bastionhost instance.
     * If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
     * If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * Description of the instance. This name can have a string of 1 to 63 characters.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
     */
    public val enablePublicAccess: Output<Boolean>
        get() = javaResource.enablePublicAccess().applyValue({ args0 -> args0 })

    /**
     * The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    public val ldapAuthServers: Output<List<InstanceLdapAuthServer>>
        get() = javaResource.ldapAuthServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceLdapAuthServerToKotlin(args0) })
            })
        })

    /**
     * The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
     */
    public val licenseCode: Output<String>
        get() = javaResource.licenseCode().applyValue({ args0 -> args0 })

    /**
     * Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The plan code of Cloud Bastionhost instance. Valid values:
     */
    public val planCode: Output<String>
        get() = javaResource.planCode().applyValue({ args0 -> args0 })

    public val publicWhiteLists: Output<List<String>>?
        get() = javaResource.publicWhiteLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
     */
    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
     * - `M`: months.
     * - `Y`: years.
     */
    public val renewalPeriodUnit: Output<String>
        get() = javaResource.renewalPeriodUnit().applyValue({ args0 -> args0 })

    /**
     * Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * security group IDs configured to Bastionhost.
     * **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
     * So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The storage of Cloud Bastionhost instance. Valid values: 0 to 500. Unit: TB.
     */
    public val storage: Output<String>
        get() = javaResource.storage().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * VSwitch ID configured to Bastionhost.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.bastionhost.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.bastionhost.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
