@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin

import com.pulumi.alicloud.bastionhost.InstanceArgs.builder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.InstanceAdAuthServerArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.InstanceAdAuthServerArgsBuilder
import com.pulumi.alicloud.bastionhost.kotlin.inputs.InstanceLdapAuthServerArgs
import com.pulumi.alicloud.bastionhost.kotlin.inputs.InstanceLdapAuthServerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Yundun_bastionhost instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:bastionhost/instance:Instance example bastionhost-exampe123456
 * ```
 * @property adAuthServers The AD auth server of the Instance. See `ad_auth_server` below.
 * @property bandwidth The bandwidth of Cloud Bastionhost instance.
 * If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
 * If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
 * @property description Description of the instance. This name can have a string of 1 to 63 characters.
 * @property enablePublicAccess Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
 * @property ldapAuthServers The LDAP auth server of the Instance. See `ldap_auth_server` below.
 * @property licenseCode The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
 * @property period Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property planCode The plan code of Cloud Bastionhost instance. Valid values:
 * @property publicWhiteLists
 * @property renewPeriod Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
 * @property renewalPeriodUnit The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
 * - `M`: months.
 * - `Y`: years.
 * @property renewalStatus Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
 * @property resourceGroupId The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
 * @property securityGroupIds security group IDs configured to Bastionhost.
 * **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
 * So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
 * and you can use tolist to convert it to a list.
 * @property storage The storage of Cloud Bastionhost instance. Valid values: 0 to 500. Unit: TB.
 * @property tags A mapping of tags to assign to the resource.
 * @property vswitchId VSwitch ID configured to Bastionhost.
 */
public data class InstanceArgs(
    public val adAuthServers: Output<List<InstanceAdAuthServerArgs>>? = null,
    public val bandwidth: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enablePublicAccess: Output<Boolean>? = null,
    public val ldapAuthServers: Output<List<InstanceLdapAuthServerArgs>>? = null,
    public val licenseCode: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val planCode: Output<String>? = null,
    public val publicWhiteLists: Output<List<String>>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalPeriodUnit: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.InstanceArgs =
        com.pulumi.alicloud.bastionhost.InstanceArgs.builder()
            .adAuthServers(
                adAuthServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enablePublicAccess(enablePublicAccess?.applyValue({ args0 -> args0 }))
            .ldapAuthServers(
                ldapAuthServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .licenseCode(licenseCode?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .planCode(planCode?.applyValue({ args0 -> args0 }))
            .publicWhiteLists(publicWhiteLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalPeriodUnit(renewalPeriodUnit?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storage(storage?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var adAuthServers: Output<List<InstanceAdAuthServerArgs>>? = null

    private var bandwidth: Output<String>? = null

    private var description: Output<String>? = null

    private var enablePublicAccess: Output<Boolean>? = null

    private var ldapAuthServers: Output<List<InstanceLdapAuthServerArgs>>? = null

    private var licenseCode: Output<String>? = null

    private var period: Output<Int>? = null

    private var planCode: Output<String>? = null

    private var publicWhiteLists: Output<List<String>>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalPeriodUnit: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The AD auth server of the Instance. See `ad_auth_server` below.
     */
    @JvmName("puollbknunxkjajc")
    public suspend fun adAuthServers(`value`: Output<List<InstanceAdAuthServerArgs>>) {
        this.adAuthServers = value
    }

    @JvmName("mmcvveuvlyeqtsqg")
    public suspend fun adAuthServers(vararg values: Output<InstanceAdAuthServerArgs>) {
        this.adAuthServers = Output.all(values.asList())
    }

    /**
     * @param values The AD auth server of the Instance. See `ad_auth_server` below.
     */
    @JvmName("lvtywwhdyurqxjgp")
    public suspend fun adAuthServers(values: List<Output<InstanceAdAuthServerArgs>>) {
        this.adAuthServers = Output.all(values)
    }

    /**
     * @param value The bandwidth of Cloud Bastionhost instance.
     * If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
     * If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
     */
    @JvmName("sxxquxegphrnsbqa")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value Description of the instance. This name can have a string of 1 to 63 characters.
     */
    @JvmName("mrikskrlvvkvxvsj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
     */
    @JvmName("hakmwukxspyoxgsl")
    public suspend fun enablePublicAccess(`value`: Output<Boolean>) {
        this.enablePublicAccess = value
    }

    /**
     * @param value The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    @JvmName("omtmhosbwkmqnefy")
    public suspend fun ldapAuthServers(`value`: Output<List<InstanceLdapAuthServerArgs>>) {
        this.ldapAuthServers = value
    }

    @JvmName("mpodcexwrugwitda")
    public suspend fun ldapAuthServers(vararg values: Output<InstanceLdapAuthServerArgs>) {
        this.ldapAuthServers = Output.all(values.asList())
    }

    /**
     * @param values The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    @JvmName("qfawwaqntawojbal")
    public suspend fun ldapAuthServers(values: List<Output<InstanceLdapAuthServerArgs>>) {
        this.ldapAuthServers = Output.all(values)
    }

    /**
     * @param value The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
     */
    @JvmName("eiaxftfkmllmfecb")
    public suspend fun licenseCode(`value`: Output<String>) {
        this.licenseCode = value
    }

    /**
     * @param value Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("gymwgwbunyjpmgsl")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The plan code of Cloud Bastionhost instance. Valid values:
     */
    @JvmName("wnumcgajxleksuhl")
    public suspend fun planCode(`value`: Output<String>) {
        this.planCode = value
    }

    /**
     * @param value
     */
    @JvmName("sorptjscvpjuejiy")
    public suspend fun publicWhiteLists(`value`: Output<List<String>>) {
        this.publicWhiteLists = value
    }

    @JvmName("fhxwwspeyhaoperk")
    public suspend fun publicWhiteLists(vararg values: Output<String>) {
        this.publicWhiteLists = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gfhyayhvxmyaghaa")
    public suspend fun publicWhiteLists(values: List<Output<String>>) {
        this.publicWhiteLists = Output.all(values)
    }

    /**
     * @param value Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
     */
    @JvmName("cxduygqelodfteoo")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
     * - `M`: months.
     * - `Y`: years.
     */
    @JvmName("djqfrsmuwmqtofry")
    public suspend fun renewalPeriodUnit(`value`: Output<String>) {
        this.renewalPeriodUnit = value
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
     */
    @JvmName("tknvdqnxnxroutqp")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
     */
    @JvmName("ykvorkkounnbaery")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value security group IDs configured to Bastionhost.
     * **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
     * So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("uxnutfrjbnhcbane")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("mmytvadwovwwgwpt")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values security group IDs configured to Bastionhost.
     * **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
     * So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("dvwkttofapbokofv")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The storage of Cloud Bastionhost instance. Valid values: 0 to 500. Unit: TB.
     */
    @JvmName("fhwwabjvmqfmqxob")
    public suspend fun storage(`value`: Output<String>) {
        this.storage = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("flnejbmhyabwnpwp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VSwitch ID configured to Bastionhost.
     */
    @JvmName("olphuwhpbdrqusmw")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The AD auth server of the Instance. See `ad_auth_server` below.
     */
    @JvmName("ejprieccuujgqaus")
    public suspend fun adAuthServers(`value`: List<InstanceAdAuthServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adAuthServers = mapped
    }

    /**
     * @param argument The AD auth server of the Instance. See `ad_auth_server` below.
     */
    @JvmName("xcsxcaebbxcseyea")
    public suspend fun adAuthServers(argument: List<suspend InstanceAdAuthServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceAdAuthServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.adAuthServers = mapped
    }

    /**
     * @param argument The AD auth server of the Instance. See `ad_auth_server` below.
     */
    @JvmName("bmgdqumpiaqiluyq")
    public suspend fun adAuthServers(vararg argument: suspend InstanceAdAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceAdAuthServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.adAuthServers = mapped
    }

    /**
     * @param argument The AD auth server of the Instance. See `ad_auth_server` below.
     */
    @JvmName("xxoujiqyoxfieixd")
    public suspend fun adAuthServers(argument: suspend InstanceAdAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceAdAuthServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.adAuthServers = mapped
    }

    /**
     * @param values The AD auth server of the Instance. See `ad_auth_server` below.
     */
    @JvmName("ximmrncwxdmpiugr")
    public suspend fun adAuthServers(vararg values: InstanceAdAuthServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adAuthServers = mapped
    }

    /**
     * @param value The bandwidth of Cloud Bastionhost instance.
     * If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
     * If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
     */
    @JvmName("dmjdxaabidxkvvrt")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Description of the instance. This name can have a string of 1 to 63 characters.
     */
    @JvmName("phowljglmnasytfh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
     */
    @JvmName("yeqetbfwrmqcjodj")
    public suspend fun enablePublicAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublicAccess = mapped
    }

    /**
     * @param value The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    @JvmName("rlredvqncylooxyg")
    public suspend fun ldapAuthServers(`value`: List<InstanceLdapAuthServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapAuthServers = mapped
    }

    /**
     * @param argument The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    @JvmName("gofrbdoauuwcgjkl")
    public suspend fun ldapAuthServers(argument: List<suspend InstanceLdapAuthServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceLdapAuthServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ldapAuthServers = mapped
    }

    /**
     * @param argument The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    @JvmName("pygkjrpcliknoyfa")
    public suspend fun ldapAuthServers(vararg argument: suspend InstanceLdapAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceLdapAuthServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ldapAuthServers = mapped
    }

    /**
     * @param argument The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    @JvmName("ikxxadwwoxcsxngt")
    public suspend fun ldapAuthServers(argument: suspend InstanceLdapAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceLdapAuthServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ldapAuthServers = mapped
    }

    /**
     * @param values The LDAP auth server of the Instance. See `ldap_auth_server` below.
     */
    @JvmName("dssdculdpvbvqmyw")
    public suspend fun ldapAuthServers(vararg values: InstanceLdapAuthServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ldapAuthServers = mapped
    }

    /**
     * @param value The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
     */
    @JvmName("eljntkbohpxnlonl")
    public suspend fun licenseCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseCode = mapped
    }

    /**
     * @param value Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("matnfmupjkubfurn")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The plan code of Cloud Bastionhost instance. Valid values:
     */
    @JvmName("jsutofaqatrvqcya")
    public suspend fun planCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("igswdwdukwsywxrh")
    public suspend fun publicWhiteLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicWhiteLists = mapped
    }

    /**
     * @param values
     */
    @JvmName("bpfdffyesdxnrfoe")
    public suspend fun publicWhiteLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicWhiteLists = mapped
    }

    /**
     * @param value Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
     */
    @JvmName("qktcslncwkjsvwpc")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
     * - `M`: months.
     * - `Y`: years.
     */
    @JvmName("dknbosqgjgdylvwm")
    public suspend fun renewalPeriodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalPeriodUnit = mapped
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
     */
    @JvmName("dnkbmineedyxcqng")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
     */
    @JvmName("qljdtfumnnfpxdxt")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value security group IDs configured to Bastionhost.
     * **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
     * So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("renbwrknuvonfbpy")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values security group IDs configured to Bastionhost.
     * **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
     * So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
     * and you can use tolist to convert it to a list.
     */
    @JvmName("qdqndyaxxncbtpas")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The storage of Cloud Bastionhost instance. Valid values: 0 to 500. Unit: TB.
     */
    @JvmName("qjexbdghskafvnba")
    public suspend fun storage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("wbwatkhvmfxksfrt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("jbnmjtijylshvgyh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VSwitch ID configured to Bastionhost.
     */
    @JvmName("djbjekyscbmmdrhh")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        adAuthServers = adAuthServers,
        bandwidth = bandwidth,
        description = description,
        enablePublicAccess = enablePublicAccess,
        ldapAuthServers = ldapAuthServers,
        licenseCode = licenseCode,
        period = period,
        planCode = planCode,
        publicWhiteLists = publicWhiteLists,
        renewPeriod = renewPeriod,
        renewalPeriodUnit = renewalPeriodUnit,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        securityGroupIds = securityGroupIds,
        storage = storage,
        tags = tags,
        vswitchId = vswitchId,
    )
}
