@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.GetHostAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHostAccounts.
 * @property hostAccountName Specify the new hosting account's name, support the longest 128 characters.
 * @property hostId Specifies the database where you want to create your hosting account's host ID.
 * @property ids A list of Host Account IDs.
 * @property instanceId Specifies the database where you want to create your hosting account's host bastion host ID of.
 * @property nameRegex A regex string to filter results by Host Account name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property protocolName Specify the new hosting account of the agreement name. Valid values: USING SSH and RDP.
 */
public data class GetHostAccountsPlainArgs(
    public val hostAccountName: String? = null,
    public val hostId: String,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val protocolName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.GetHostAccountsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.GetHostAccountsPlainArgs =
        com.pulumi.alicloud.bastionhost.inputs.GetHostAccountsPlainArgs.builder()
            .hostAccountName(hostAccountName?.let({ args0 -> args0 }))
            .hostId(hostId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .protocolName(protocolName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetHostAccountsPlainArgsBuilder internal constructor() {
    private var hostAccountName: String? = null

    private var hostId: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var protocolName: String? = null

    /**
     * @param value Specify the new hosting account's name, support the longest 128 characters.
     */
    @JvmName("ychxrtmigheeiqwe")
    public suspend fun hostAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostAccountName = mapped
    }

    /**
     * @param value Specifies the database where you want to create your hosting account's host ID.
     */
    @JvmName("bfwrydhycgqgqjve")
    public suspend fun hostId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostId = mapped
    }

    /**
     * @param value A list of Host Account IDs.
     */
    @JvmName("auybuhluaexxilwk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Host Account IDs.
     */
    @JvmName("weexkfrjjmtqbrlk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Specifies the database where you want to create your hosting account's host bastion host ID of.
     */
    @JvmName("ellkbvoeeulkyhxu")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Host Account name.
     */
    @JvmName("wbaynjynrgmwvkmr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ephjskstypgcikhf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Specify the new hosting account of the agreement name. Valid values: USING SSH and RDP.
     */
    @JvmName("ewpsmvbstoiqkvse")
    public suspend fun protocolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocolName = mapped
    }

    internal fun build(): GetHostAccountsPlainArgs = GetHostAccountsPlainArgs(
        hostAccountName = hostAccountName,
        hostId = hostId ?: throw PulumiNullFieldException("hostId"),
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        protocolName = protocolName,
    )
}
