@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.GetHostGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHostGroups.
 * @property hostGroupName Specify the New Host Group Name, Supports up to 128 Characters.
 * @property ids A list of Host Group IDs.
 * @property instanceId Specify the New Host Group Where the Bastion Host ID of.
 * @property nameRegex A regex string to filter results by Host Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetHostGroupsPlainArgs(
    public val hostGroupName: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.GetHostGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.GetHostGroupsPlainArgs =
        com.pulumi.alicloud.bastionhost.inputs.GetHostGroupsPlainArgs.builder()
            .hostGroupName(hostGroupName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetHostGroupsPlainArgsBuilder internal constructor() {
    private var hostGroupName: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value Specify the New Host Group Name, Supports up to 128 Characters.
     */
    @JvmName("chymqwwffivfghop")
    public suspend fun hostGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostGroupName = mapped
    }

    /**
     * @param value A list of Host Group IDs.
     */
    @JvmName("ybxtqfjsulagskdv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Host Group IDs.
     */
    @JvmName("cwlwvsrliatuelrv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Specify the New Host Group Where the Bastion Host ID of.
     */
    @JvmName("adigxyjkxsccinvb")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Host Group name.
     */
    @JvmName("swfimwtagqsskaqf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("digvjnuiitljfxmi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetHostGroupsPlainArgs = GetHostGroupsPlainArgs(
        hostGroupName = hostGroupName,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
