@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.GetHostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHosts.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property hostAddress The host address.
 * @property hostName Specify the new create a host name of the supports up to 128 characters.
 * @property ids A list of Host IDs.
 * @property instanceId Specify the new create a host where the Bastion host ID of.
 * @property nameRegex A regex string to filter results by Host name.
 * @property osType Specify the new create the host's operating system. Valid values: Linux Windows.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property source Specify the new create a host of source. Valid values: Local: localhost Ecs:ECS instance Rds:RDS exclusive cluster host.
 * @property sourceInstanceId Specify the newly created ECS instance ID or dedicated cluster host ID.
 * @property sourceInstanceState The source instance state.
 */
public data class GetHostsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val hostAddress: String? = null,
    public val hostName: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val source: String? = null,
    public val sourceInstanceId: String? = null,
    public val sourceInstanceState: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.GetHostsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.GetHostsPlainArgs =
        com.pulumi.alicloud.bastionhost.inputs.GetHostsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .hostAddress(hostAddress?.let({ args0 -> args0 }))
            .hostName(hostName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .osType(osType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .source(source?.let({ args0 -> args0 }))
            .sourceInstanceId(sourceInstanceId?.let({ args0 -> args0 }))
            .sourceInstanceState(sourceInstanceState?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostsPlainArgs].
 */
@PulumiTagMarker
public class GetHostsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var hostAddress: String? = null

    private var hostName: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var osType: String? = null

    private var outputFile: String? = null

    private var source: String? = null

    private var sourceInstanceId: String? = null

    private var sourceInstanceState: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("mlkmigpknmfhayju")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The host address.
     */
    @JvmName("lljscaumwircnegc")
    public suspend fun hostAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostAddress = mapped
    }

    /**
     * @param value Specify the new create a host name of the supports up to 128 characters.
     */
    @JvmName("grwasyownqsqucdo")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostName = mapped
    }

    /**
     * @param value A list of Host IDs.
     */
    @JvmName("lvgffuyukxmdoqed")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Host IDs.
     */
    @JvmName("opldqfeqcevfmjlf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Specify the new create a host where the Bastion host ID of.
     */
    @JvmName("cxddtnyekquufpvy")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by Host name.
     */
    @JvmName("frkbftfosmwkpvlf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Specify the new create the host's operating system. Valid values: Linux Windows.
     */
    @JvmName("qhsgdkfkphublyqm")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.osType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("shcccofefwqumldd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Specify the new create a host of source. Valid values: Local: localhost Ecs:ECS instance Rds:RDS exclusive cluster host.
     */
    @JvmName("bknheeobcikrasim")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.source = mapped
    }

    /**
     * @param value Specify the newly created ECS instance ID or dedicated cluster host ID.
     */
    @JvmName("xpixupglejcmwjeb")
    public suspend fun sourceInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceInstanceId = mapped
    }

    /**
     * @param value The source instance state.
     */
    @JvmName("hgogephrhamttovl")
    public suspend fun sourceInstanceState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceInstanceState = mapped
    }

    internal fun build(): GetHostsPlainArgs = GetHostsPlainArgs(
        enableDetails = enableDetails,
        hostAddress = hostAddress,
        hostName = hostName,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        osType = osType,
        outputFile = outputFile,
        source = source,
        sourceInstanceId = sourceInstanceId,
        sourceInstanceState = sourceInstanceState,
    )
}
