@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property descriptionRegex A regex string to filter results by the instance description.
 * @property ids Matched instance IDs to filter data source result.
 * @property outputFile File name to persist data source output.
 * @property tags A map of tags assigned to the bastionhost instance. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const instance = alicloud.bastionhost.getInstances({
 *     tags: {
 *         tagKey1: "tagValue1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * instance = alicloud.bastionhost.get_instances(tags={
 *     "tagKey1": "tagValue1",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instance = AliCloud.BastionHost.GetInstances.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bastionhost.GetInstances(ctx, &bastionhost.GetInstancesArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
 * import com.pulumi.alicloud.bastionhost.inputs.GetInstancesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var instance = BastionhostFunctions.getInstances(GetInstancesArgs.builder()
 *             .tags(Map.of("tagKey1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   instance:
 *     fn::invoke:
 *       Function: alicloud:bastionhost:getInstances
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 * ```
 * <!--End PulumiCodeChooser -->
 */
public data class GetInstancesPlainArgs(
    public val descriptionRegex: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.bastionhost.inputs.GetInstancesPlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A regex string to filter results by the instance description.
     */
    @JvmName("nkqhppghfcnwikml")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value Matched instance IDs to filter data source result.
     */
    @JvmName("kcrdqouojjnsjnuc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values Matched instance IDs to filter data source result.
     */
    @JvmName("hdyqplspenodtepd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name to persist data source output.
     */
    @JvmName("ywpadhbowajpqymi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A map of tags assigned to the bastionhost instance. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instance = alicloud.bastionhost.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instance = alicloud.bastionhost.get_instances(tags={
     *     "tagKey1": "tagValue1",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instance = AliCloud.BastionHost.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bastionhost.GetInstances(ctx, &bastionhost.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instance = BastionhostFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.of("tagKey1", "tagValue1"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instance:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("gnhfdavhitklxxgf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the bastionhost instance. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instance = alicloud.bastionhost.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instance = alicloud.bastionhost.get_instances(tags={
     *     "tagKey1": "tagValue1",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instance = AliCloud.BastionHost.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bastionhost.GetInstances(ctx, &bastionhost.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
     * import com.pulumi.alicloud.bastionhost.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instance = BastionhostFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.of("tagKey1", "tagValue1"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instance:
     *     fn::invoke:
     *       Function: alicloud:bastionhost:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("cwtjavypcrljdyvt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        descriptionRegex = descriptionRegex,
        ids = ids,
        outputFile = outputFile,
        tags = tags,
    )
}
