@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.GetUserGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserGroups.
 * @property ids A list of User Group self IDs.
 * @property instanceId Specify the New Group of the Bastion Host of Instance Id.
 * @property nameRegex A regex string to filter results by User Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property userGroupName Specify the New Group Name. Supports up to 128 Characters.
 */
public data class GetUserGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val userGroupName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.GetUserGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.GetUserGroupsPlainArgs =
        com.pulumi.alicloud.bastionhost.inputs.GetUserGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .userGroupName(userGroupName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetUserGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var userGroupName: String? = null

    /**
     * @param value A list of User Group self IDs.
     */
    @JvmName("wwbhmkbuwtfshnxh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of User Group self IDs.
     */
    @JvmName("gjjeuitamyiexoxt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Specify the New Group of the Bastion Host of Instance Id.
     */
    @JvmName("nbvxxnmartrbsavs")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by User Group name.
     */
    @JvmName("ublxqhgdvxupduju")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dvjeqtnyqwblowxb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Specify the New Group Name. Supports up to 128 Characters.
     */
    @JvmName("xicexcqkuduxlhym")
    public suspend fun userGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userGroupName = mapped
    }

    internal fun build(): GetUserGroupsPlainArgs = GetUserGroupsPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        userGroupName = userGroupName,
    )
}
